/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.group;

import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.api.storage.blacklist.BlacklistCreator;
import de.rayzs.pat.api.storage.blacklist.impl.GroupBlacklist;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.group.Group;
import de.rayzs.pat.utils.group.TinyGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class GroupManager {
    private static final List<Group> GROUPS = new LinkedList<Group>();

    public static void initialize() {
        Storage.Files.STORAGE.getKeys("groups", false).forEach(GroupManager::registerGroup);
        if (!Reflection.isProxyServer()) {
            return;
        }
        GroupManager.getGroups().forEach(group -> Storage.Files.STORAGE.getKeys("groups." + group.getGroupName() + ".servers", false).forEach(key -> group.getOrCreateGroupBlacklist((String)key, true)));
    }

    public static List<Group> getPlayerGroups(Object player) {
        int invalidPriority = 0x7FFFFFFE;
        ArrayList<Group> playerGroups = new ArrayList<Group>(GroupManager.getGroups().stream().filter(group -> group.hasPermission(player)).toList());
        int priority = playerGroups.stream().mapToInt(Group::getPriority).filter(group -> group <= 0x7FFFFFFE).min().orElse(0x7FFFFFFE);
        playerGroups.removeIf(group -> group.getPriority() > priority);
        return playerGroups;
    }

    public static List<Group> getPlayerGroups(UUID uuid) {
        int invalidPriority = 0x7FFFFFFE;
        ArrayList<Group> playerGroups = new ArrayList<Group>(GroupManager.getGroups().stream().filter(group -> group.hasPermission(uuid)).toList());
        int priority = playerGroups.stream().mapToInt(Group::getPriority).filter(group -> group <= 0x7FFFFFFE).min().orElse(0x7FFFFFFE);
        playerGroups.removeIf(group -> group.getPriority() > priority);
        return playerGroups;
    }

    public static boolean canAccessCommand(Object targetObj, String unmodifiedCommand, Storage.Blacklist.BlockType type) {
        return GroupManager.canAccessCommand(targetObj, unmodifiedCommand, type, null);
    }

    public static boolean canAccessCommand(Object targetObj, String unmodifiedCommand, Storage.Blacklist.BlockType type, String server) {
        List<Group> playerGroups = GroupManager.getPlayerGroups(targetObj);
        if (playerGroups.isEmpty()) {
            return false;
        }
        String command = type.toString() + unmodifiedCommand;
        boolean permitted = playerGroups.stream().anyMatch(group -> {
            if (group == null) {
                return false;
            }
            if (server != null) {
                List<String> servers = group.getBlacklistServerNames(server);
                for (String s : servers) {
                    if (!group.contains(command, s)) continue;
                    return true;
                }
            }
            return group.contains(command);
        });
        if (!permitted && type != Storage.Blacklist.BlockType.BOTH) {
            return GroupManager.canAccessCommand(targetObj, unmodifiedCommand, Storage.Blacklist.BlockType.BOTH, server);
        }
        return permitted;
    }

    public static void setGroup(String groupName, List<String> commands) {
        GroupManager.setGroup(groupName, 1, commands);
    }

    public static void setGroup(String groupName, int priority, List<String> commands) {
        if (groupName.isEmpty()) {
            return;
        }
        Group group = GroupManager.registerAndGetGroup(groupName, priority);
        group.setCommands(commands);
    }

    public static Group registerAndGetGroup(String groupName) {
        return GroupManager.registerAndGetGroup(groupName, 1);
    }

    public static Group registerAndGetGroup(String groupName, int priority) {
        Group group = GroupManager.getGroupByName(groupName);
        if (group != null) {
            return group;
        }
        group = new Group(groupName, priority);
        GROUPS.add(group);
        GroupManager.sort();
        return group;
    }

    public static void sort() {
        GROUPS.sort(Comparator.comparingInt(Group::getPriority));
    }

    public static void registerGroup(String groupName) {
        if (GroupManager.isGroupRegistered(groupName)) {
            return;
        }
        GROUPS.add(new Group(groupName));
        GroupManager.sort();
    }

    public static void addToGroup(String groupName, String command) {
        Group group = GroupManager.getGroupByName(groupName);
        if (groupName == null) {
            return;
        }
        group.add(command);
    }

    public static void addToGroup(String groupName, String command, String server) {
        Group group = GroupManager.getGroupByName(groupName);
        if (groupName == null) {
            return;
        }
        group.add(command, server);
    }

    public static void removeFromGroup(String groupName, String command) {
        Group group = GroupManager.getGroupByName(groupName);
        if (groupName == null) {
            return;
        }
        group.remove(command);
    }

    public static void removeFromGroup(String groupName, String command, String server) {
        Group group = GroupManager.getGroupByName(groupName);
        if (groupName == null) {
            return;
        }
        group.remove(command, server);
    }

    public static void unregisterGroup(String groupName) {
        GroupManager.unregisterGroup(groupName, null);
    }

    public static void unregisterGroup(String groupName, String server) {
        Group group = GroupManager.getGroupByName(groupName);
        if (group == null) {
            return;
        }
        if (server != null) {
            group.deleteGroup(server);
        } else {
            group.deleteGroup();
        }
        GROUPS.remove(group);
        GroupManager.sort();
    }

    public static Group getGroupByName(String groupName) {
        return GROUPS.stream().filter(group -> group.getGroupName().equals(groupName)).findFirst().orElse(null);
    }

    public static List<Group> getGroups() {
        return GROUPS;
    }

    public static List<String> getGroupNames() {
        ArrayList<String> result = new ArrayList<String>();
        GROUPS.forEach(group -> result.add(group.getGroupName()));
        return result;
    }

    public static List<String> getGroupNamesByServer(String server) {
        ArrayList<String> result = new ArrayList<String>();
        GroupManager.getGroupsByServer(server).forEach(group -> result.add(group.getGroupName()));
        return result;
    }

    public static void clearServerGroupBlacklists() {
        GROUPS.forEach(Group::clearServerGroupBlacklistsCache);
    }

    public static List<Group> getGroupsByServer(String server) {
        ArrayList<Group> result = new ArrayList<Group>();
        GROUPS.stream().filter(group -> {
            if (BlacklistCreator.exist(group.getGroupName(), server)) {
                GroupBlacklist groupBlacklist = group.getOrCreateGroupBlacklist(server);
                return groupBlacklist != null && groupBlacklist.getCommands().size() >= 1;
            }
            return false;
        }).forEach(result::add);
        return result;
    }

    public static TinyGroup convertToTinyGroup(String groupName, int priority, List<String> commands) {
        return new TinyGroup(groupName, priority, commands);
    }

    public static void clearAllGroups() {
        GROUPS.clear();
    }

    public static boolean isGroupRegistered(String groupName) {
        return GroupManager.getGroupByName(groupName) != null;
    }
}

