/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.message.replacer.impl;

import com.velocitypowered.api.proxy.Player;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.sender.CommandSender;
import java.util.UUID;
import java.util.function.Consumer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.william278.papiproxybridge.api.PlaceholderAPI;

public class ProxyPlaceholderReplacer {
    private final PlaceholderAPI placeholderAPI = PlaceholderAPI.createInstance();

    public ProxyPlaceholderReplacer() {
        this.placeholderAPI.setRequestTimeout(1500L);
    }

    public boolean process(Object playerObj, String text, Consumer<String> consumer) {
        UUID uuid = null;
        if (playerObj != null) {
            if (playerObj instanceof CommandSender) {
                uuid = ((CommandSender)playerObj).getUniqueId();
            } else if (Reflection.isVelocityServer()) {
                if (playerObj instanceof Player) {
                    uuid = ((Player)playerObj).getUniqueId();
                }
            } else if (Reflection.isProxyServer()) {
                if (playerObj instanceof ProxiedPlayer) {
                    uuid = ((ProxiedPlayer)playerObj).getUniqueId();
                }
            } else if (playerObj instanceof org.bukkit.entity.Player) {
                uuid = ((org.bukkit.entity.Player)playerObj).getUniqueId();
            }
        }
        if (uuid == null) {
            return false;
        }
        this.placeholderAPI.formatPlaceholders(text, uuid).thenAccept(consumer);
        return true;
    }
}

