/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.response.action.impl;

import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.message.replacer.PlaceholderReplacer;
import de.rayzs.pat.utils.response.ResponseHandler;
import de.rayzs.pat.utils.response.action.Action;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class OldBukkitAction
implements Action {
    private String versionPackage = null;

    @Override
    public void executeConsoleCommand(String action, UUID uuid, String command, String message) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        message = ResponseHandler.replaceArgsVariables(message, command);
        if (player != null) {
            message = message.replace("%player%", player.getName());
        }
        if (message.contains("%")) {
            message = PlaceholderReplacer.replace(player, message);
        }
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)message);
    }

    @Override
    public void executePlayerCommand(String action, UUID uuid, String command, String message) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        message = ResponseHandler.replaceArgsVariables(message, command);
        if (player != null) {
            message = message.replace("%player%", player.getName());
        }
        if (message.contains("%")) {
            message = PlaceholderReplacer.replace(player, message);
        }
        if (player != null) {
            Bukkit.dispatchCommand((CommandSender)player, (String)message);
        }
    }

    @Override
    public void sendTitle(String action, UUID uuid, String command, String title, String subTitle, int fadeIn, int stay, int fadeOut) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        title = ResponseHandler.replaceArgsVariables(title, command);
        subTitle = ResponseHandler.replaceArgsVariables(subTitle, command);
        if (player == null) {
            return;
        }
        title = PlaceholderReplacer.replace(player, StringUtils.replace(title, "&", "\u00a7", "%player%", player.getName()));
        subTitle = PlaceholderReplacer.replace(player, StringUtils.replace(subTitle, "&", "\u00a7", "%player%", player.getName()));
        player.sendTitle(title, subTitle);
    }

    @Override
    public void addPotionEffect(String action, UUID uuid, String potionEffectTypeName, int duration, int amplifier) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        PotionEffectType potionEffectType = null;
        try {
            potionEffectType = PotionEffectType.getByName((String)potionEffectTypeName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (potionEffectType == null) {
            Logger.warning("! Failed to read action: " + action);
            Logger.warning("  > The effect \"" + potionEffectTypeName + "\" could not be found!");
            Logger.warning("  > Here's an example of an existing effect:");
            Logger.warning("  > BLINDNESS, REGENERATION");
            return;
        }
        player.addPotionEffect(new PotionEffect(potionEffectType, duration, amplifier));
    }

    @Override
    public void playSound(String action, UUID uuid, String soundName, float volume, float pitch) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        try {
            Sound sound = Sound.valueOf((String)soundName);
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
        catch (Exception exception) {
            Logger.warning("! Failed to read action: " + action);
            Logger.warning("  > The sound \"" + soundName + "\" could not be found!");
            Logger.warning("  > Here's an example of an existing sound effect:");
            Logger.warning("  > ENTITY_ENDER_DRAGON_GROWL");
        }
    }

    @Override
    public void sendActionbar(String action, UUID uuid, String command, String message) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        message = ResponseHandler.replaceArgsVariables(message, command);
        if (player == null) {
            return;
        }
        message = PlaceholderReplacer.replace(player, StringUtils.replace(message, "&", "\u00a7", "%player%", player.getName()));
        try {
            if (this.versionPackage == null) {
                this.versionPackage = Reflection.getVersionPackageName();
            }
            Object entityPlayer = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Constructor<?> constructor = Objects.requireNonNull(Class.forName("net.minecraft.server." + this.versionPackage + ".PacketPlayOutChat")).getConstructor(Class.forName("net.minecraft.server." + this.versionPackage + ".IChatBaseComponent"), Byte.TYPE);
            Object iChatBaseComponent = Objects.requireNonNull(Class.forName("net.minecraft.server." + this.versionPackage + ".IChatBaseComponent")).getDeclaredClasses()[0].getMethod("a", String.class).invoke(null, "{\"text\":\"" + message + "\"}");
            Object actionbarPacket = constructor.newInstance(iChatBaseComponent, (byte)2);
            Object playerConnection = entityPlayer.getClass().getField("playerConnection").get(entityPlayer);
            playerConnection.getClass().getMethod("sendPacket", Class.forName("net.minecraft.server." + this.versionPackage + ".Packet")).invoke(playerConnection, actionbarPacket);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
            Logger.warning("! Failed to run action: " + action);
            Logger.warning("  > Actionbars are not supported in this server version!");
        }
    }
}

