/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin.listeners.velocity;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.command.PlayerAvailableCommandsEvent;
import com.velocitypowered.api.event.player.TabCompleteEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import de.rayzs.pat.api.event.PATEventHandler;
import de.rayzs.pat.api.event.events.FilteredSuggestionEvent;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.utils.CommandsCache;
import de.rayzs.pat.utils.permission.PermissionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VelocityAntiTabListener {
    private static ProxyServer server;

    public VelocityAntiTabListener(ProxyServer server) {
        VelocityAntiTabListener.server = server;
    }

    @Subscribe(order=PostOrder.LAST)
    public void onTabComplete(TabCompleteEvent event) {
        String serverName;
        Player player = event.getPlayer();
        String string = serverName = player.getCurrentServer().isPresent() ? ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName() : "unknown";
        if (Storage.Blacklist.isDisabledServer(serverName)) {
            return;
        }
        if (PermissionUtil.hasBypassPermission(player) || event.getSuggestions().isEmpty() || !player.getCurrentServer().isPresent()) {
            return;
        }
        event.getSuggestions().removeIf(command -> !Storage.Blacklist.canPlayerAccessTab(player, command, serverName));
        FilteredSuggestionEvent filteredSuggestionEvent = PATEventHandler.callFilteredSuggestionEvents(player, event.getSuggestions());
        if (filteredSuggestionEvent.isCancelled()) {
            event.getSuggestions().clear();
        }
    }

    @Subscribe(order=PostOrder.LAST)
    public void onPlayerAvailableCommands(PlayerAvailableCommandsEvent event) {
        Player player = event.getPlayer();
        if (event.getRootNode().getChildren().isEmpty() || !player.getCurrentServer().isPresent()) {
            return;
        }
        String serverName = ((ServerConnection)player.getCurrentServer().get()).getServer().getServerInfo().getName();
        HashMap<String, CommandsCache> cache = Storage.getLoader().getCommandsCacheMap();
        if (!cache.containsKey(serverName)) {
            cache.put(serverName, new CommandsCache());
        }
        CommandsCache commandsCache = (CommandsCache)cache.get(serverName);
        ArrayList<String> commandsAsString = new ArrayList<String>();
        event.getRootNode().getChildren().stream().filter(command -> command != null && command.getName() != null).forEach(command -> commandsAsString.add(command.getName()));
        commandsCache.handleCommands(commandsAsString, serverName);
        if (PermissionUtil.hasBypassPermission(player)) {
            return;
        }
        boolean newer = player.getProtocolVersion().getProtocol() > 340;
        boolean argsChildrenExist = event.getRootNode().getChild("args") != null;
        List<String> playerCommands = commandsCache.getPlayerCommands(commandsAsString, player, player.getUniqueId(), serverName);
        if (event.getRootNode().getChildren().size() == 1 && newer && argsChildrenExist && event.getRootNode().getChild("args").getChildren().isEmpty()) {
            return;
        }
        if (event.getRootNode().getChildren().size() == 1 && newer && argsChildrenExist) {
            return;
        }
        event.getRootNode().getChildren().removeIf(command -> {
            if (command == null || command.getName() == null) {
                return true;
            }
            if (command.getName().equals("args")) {
                return false;
            }
            return !playerCommands.contains(command.getName());
        });
    }
}

