/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.message.translators;

import de.rayzs.pat.plugin.BungeeLoader;
import de.rayzs.pat.utils.message.MessageTranslator;
import de.rayzs.pat.utils.message.Translator;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bungeecord.BungeeAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BungeeMessageTranslator
implements Translator {
    private BungeeAudiences audiences;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public BungeeMessageTranslator() {
        this.audiences = BungeeAudiences.create(BungeeLoader.getPlugin());
    }

    @Override
    public String translate(String text) {
        return (String)this.miniMessage.serialize(this.miniMessage.deserialize(MessageTranslator.translateLegacy(text)));
    }

    @Override
    public void send(Object target, String text) {
        Audience audience = target instanceof ProxiedPlayer ? this.audiences.player((ProxiedPlayer)target) : this.audiences.sender((CommandSender)target);
        text = (String)this.miniMessage.serialize(LegacyComponentSerializer.legacyAmpersand().deserialize(text.replace("\u00a7", "&")));
        if (text.contains("\\")) {
            text = text.replace("\\", "");
        }
        audience.sendMessage((Component)this.miniMessage.deserialize(text));
    }

    @Override
    public void close() {
        this.audiences.close();
        this.audiences = null;
    }
}

