/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.sender.impl;

import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.utils.message.MessageTranslator;
import de.rayzs.pat.utils.sender.CommandSenderAbstract;
import de.rayzs.pat.utils.sender.CommandSenderHandler;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitSender
extends CommandSenderAbstract {
    private final CommandSender sender;
    private final UUID uuid;
    private final String name;
    private final boolean console;

    public BukkitSender(Object senderObj) {
        super(senderObj);
        if (senderObj instanceof Player) {
            Player player = (Player)senderObj;
            this.sender = player;
            this.name = player.getName();
            this.uuid = player.getUniqueId();
            this.console = false;
            return;
        }
        this.sender = (CommandSender)senderObj;
        if (this.sender != null) {
            this.name = this.sender.getName();
            this.uuid = CommandSenderHandler.CONSOLE_UUID;
        } else {
            this.name = null;
            this.uuid = null;
        }
        this.console = true;
    }

    @Override
    public Object getSenderObject() {
        return this.sender;
    }

    @Override
    public boolean isConsole() {
        return this.console;
    }

    @Override
    public boolean isPlayer() {
        return !this.console;
    }

    @Override
    public boolean isOperator() {
        return this.sender.isOp();
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.sender.hasPermission(permission);
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getServerName() {
        return Storage.SERVER_NAME;
    }

    @Override
    public void sendMessage(String message) {
        if (MessageTranslator.isSupported()) {
            MessageTranslator.send((Object)this.sender, message, new String[0]);
            return;
        }
        this.sender.sendMessage(MessageTranslator.replaceMessage(this.sender, message));
    }
}

