/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.command;

import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.sender.CommandSender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ProCommand {
    private final String name;
    private final List<String> aliases;
    protected boolean proxyOnly = false;
    protected boolean serverCommand = false;

    public ProCommand(String name, String ... aliases) {
        this.name = name.toLowerCase();
        this.aliases = aliases != null && !aliases[0].isBlank() ? Arrays.asList(aliases) : new ArrayList<String>();
    }

    public String getName() {
        return this.name;
    }

    public boolean isProxyOnly() {
        return this.proxyOnly;
    }

    public boolean isServerCommand() {
        return this.serverCommand;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCommand(String label) {
        String commandName = StringUtils.getFirstArg(label);
        if (this.name.equalsIgnoreCase(commandName)) {
            return true;
        }
        if (this.aliases.isEmpty()) return false;
        if (!this.aliases.stream().anyMatch(commandName::equalsIgnoreCase)) return false;
        return true;
    }

    public abstract boolean execute(CommandSender var1, String[] var2);

    public abstract List<String> tabComplete(CommandSender var1, String[] var2);
}

