/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.communication.impl;

import de.rayzs.pat.api.communication.Client;
import de.rayzs.pat.api.communication.Communicator;
import de.rayzs.pat.plugin.BukkitLoader;
import de.rayzs.pat.utils.CommunicationPackets;
import de.rayzs.pat.utils.scheduler.PATScheduler;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BukkitClient
implements Client,
PluginMessageListener {
    private static final Server SERVER = Bukkit.getServer();

    public BukkitClient() {
        SERVER.getMessenger().registerIncomingPluginChannel(BukkitLoader.getPlugin(), "pat:channel", (PluginMessageListener)this);
        SERVER.getMessenger().registerOutgoingPluginChannel(BukkitLoader.getPlugin(), "pat:channel");
    }

    @Override
    public void send(Object packet) {
        try {
            SERVER.sendPluginMessage(BukkitLoader.getPlugin(), "pat:channel", CommunicationPackets.convertToBytes(packet));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] bytes) {
        if (!channel.equals("pat:channel")) {
            return;
        }
        try {
            Object packetObj = CommunicationPackets.buildFromBytes(bytes);
            if (!CommunicationPackets.isPacket(packetObj)) {
                return;
            }
            PATScheduler.createScheduler(() -> Communicator.receiveInformation("proxy", packetObj));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

