/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.netty.bukkit.handlers;

import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import de.rayzs.pat.api.event.PATEventHandler;
import de.rayzs.pat.api.event.events.FilteredTabCompletionEvent;
import de.rayzs.pat.api.netty.bukkit.BukkitPacketAnalyzer;
import de.rayzs.pat.api.netty.bukkit.BukkitPacketHandler;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.BukkitLoader;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.message.MessageTranslator;
import de.rayzs.pat.utils.scheduler.PATScheduler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ModernPacketHandler
implements BukkitPacketHandler {
    private static boolean modifiable = true;

    @Override
    public boolean handleIncomingPacket(Player player, Object packetObj) throws Exception {
        Field stringField = Reflection.getFirstFieldByType(packetObj.getClass(), "String", Reflection.SearchOption.ENDS);
        if (stringField == null) {
            Logger.warning("Failed PacketAnalyze process! (#1)");
            return false;
        }
        String text = (String)stringField.get(packetObj);
        if (Storage.ConfigSections.Settings.PATCH_EXPLOITS.isMalicious(text)) {
            MessageTranslator.send((Object)Bukkit.getConsoleSender(), Storage.ConfigSections.Settings.PATCH_EXPLOITS.ALERT_MESSAGE.get().replace("%player%", player.getName()), new String[0]);
            PATScheduler.createScheduler(() -> player.kickPlayer(StringUtils.replace(Storage.ConfigSections.Settings.PATCH_EXPLOITS.KICK_MESSAGE.get(), "&", "\u00a7")));
            return false;
        }
        BukkitPacketAnalyzer.insertPlayerInput(player, text);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean handleOutgoingPacket(Player player, Object packetObj) throws Exception {
        Object suggestionObj;
        Field suggestionsField;
        String rawInput = BukkitPacketAnalyzer.getPlayerInput(player);
        String input = rawInput;
        if (input == null) {
            return false;
        }
        boolean is121Packet = packetObj.getClass().getSimpleName().equals("ClientboundCommandSuggestionsPacket");
        boolean cancelsBeforeHand = false;
        int spaces = 0;
        if (input.startsWith("/") || is121Packet) {
            String[] split;
            if ((input = input.replace("/", "")).contains(" ") && (spaces = (split = input.split(" ")).length) > 0) {
                input = split[0];
            }
            boolean bl = cancelsBeforeHand = !Storage.Blacklist.canPlayerAccessTab(player, input);
            if (!cancelsBeforeHand) {
                boolean bl2 = cancelsBeforeHand = Storage.ConfigSections.Settings.CUSTOM_VERSION.isTabCompletable(input) || Storage.ConfigSections.Settings.CUSTOM_PLUGIN.isTabCompletable(input);
            }
        }
        if (is121Packet || Reflection.isFoliaServer() && packetObj.getClass().getSimpleName().equals("PacketPlayOutTabComplete")) {
            try {
                void var19_25;
                suggestionsField = Reflection.getFieldsByTypeNormal(packetObj.getClass(), "List", Reflection.SearchOption.ENDS).get(0);
                List suggestionsTmp = (List)suggestionsField.get(packetObj);
                ArrayList<Object> suggestions = new ArrayList<Object>(suggestionsTmp);
                List<Field> intFields = Reflection.getFieldsByTypeNormal(packetObj.getClass(), "int", Reflection.SearchOption.ENDS);
                int id = (Integer)intFields.get(0).get(packetObj);
                int start = (Integer)intFields.get(1).get(packetObj);
                int length = (Integer)intFields.get(2).get(packetObj);
                Class<?> clientboundCommandSuggestionsPacketClass = Class.forName("net.minecraft.network.protocol.game." + (packetObj.getClass().getSimpleName().equals("PacketPlayOutTabComplete") ? "PacketPlayOutTabComplete" : "ClientboundCommandSuggestionsPacket"));
                if ((input.isEmpty() || cancelsBeforeHand) && Reflection.isWeird()) {
                    return false;
                }
                if (spaces >= 1 && cancelsBeforeHand || !BukkitLoader.isLoaded()) {
                    suggestions.clear();
                    return true;
                }
                if (spaces == 0) {
                    suggestions.removeIf(suggestion -> {
                        String command = this.getSuggestionFromEntry(suggestion);
                        return !Storage.Blacklist.canPlayerAccessTab(player, command);
                    });
                    return true;
                }
                ArrayList<String> suggestionsAsString = new ArrayList<String>();
                for (Object e : suggestions) {
                    suggestionsAsString.add(this.getSuggestionFromEntry(e));
                }
                FilteredTabCompletionEvent filteredTabCompletionEvent = PATEventHandler.callFilteredTabCompletionEvents(player.getUniqueId(), rawInput, suggestionsAsString);
                if (filteredTabCompletionEvent.isCancelled()) {
                    suggestions.clear();
                }
                boolean bl = false;
                while (var19_25 < suggestions.size()) {
                    Object csO = suggestions.get((int)var19_25);
                    String suggestionAsString = this.getSuggestionFromEntry(csO);
                    if (!filteredTabCompletionEvent.getCompletion().contains(suggestionAsString)) {
                        suggestions.remove(csO);
                    }
                    ++var19_25;
                }
                suggestions.removeIf(suggestion -> !filteredTabCompletionEvent.getCompletion().contains(this.getSuggestionFromEntry(suggestion)));
                if (!suggestions.isEmpty()) {
                    Object clientboundCommandSuggestionsPacketObj = clientboundCommandSuggestionsPacketClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, List.class).newInstance(id, start, length, suggestions);
                    BukkitPacketAnalyzer.sendPacket(player.getUniqueId(), clientboundCommandSuggestionsPacketObj);
                }
                return false;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return !cancelsBeforeHand;
            }
        }
        if (Reflection.getMinor() < 17) {
            suggestionsField = Reflection.getFieldsByType(packetObj.getClass(), "Suggestions", Reflection.SearchOption.ENDS).get(0);
            if (suggestionsField == null) {
                return false;
            }
            suggestionObj = suggestionsField.get(packetObj);
        } else {
            List<Method> methods = Reflection.getMethodsByReturnType(packetObj.getClass(), "Suggestions", Reflection.SearchOption.ENDS);
            if (methods.isEmpty()) {
                return false;
            }
            Method suggestionsMethod = methods.get(0);
            if (suggestionsMethod == null) {
                return false;
            }
            suggestionObj = suggestionsMethod.invoke(packetObj, new Object[0]);
        }
        Suggestions suggestions = (Suggestions)suggestionObj;
        if ((input.isEmpty() || cancelsBeforeHand) && Reflection.isWeird()) {
            return false;
        }
        if (spaces >= 1 && cancelsBeforeHand || !BukkitLoader.isLoaded()) {
            suggestions.getList().clear();
            return true;
        }
        if (spaces == 0) {
            suggestions.getList().removeIf(suggestion -> {
                String command = suggestion.getText();
                return !Storage.Blacklist.canPlayerAccessTab(player, command);
            });
            return true;
        }
        ArrayList<String> suggestionsAsString = new ArrayList<String>();
        for (Suggestion suggestion3 : suggestions.getList()) {
            suggestionsAsString.add(suggestion3.getText());
        }
        FilteredTabCompletionEvent filteredTabCompletionEvent = PATEventHandler.callFilteredTabCompletionEvents(player.getUniqueId(), rawInput, suggestionsAsString);
        if (modifiable) {
            try {
                if (filteredTabCompletionEvent.isCancelled()) {
                    suggestions.getList().clear();
                } else {
                    suggestions.getList().removeIf(suggestion -> !filteredTabCompletionEvent.getCompletion().contains(suggestion.getText()));
                }
                return !suggestions.getList().isEmpty();
            }
            catch (UnsupportedOperationException exception) {
                modifiable = false;
            }
        }
        return this.handleUnmodifiableTabCompletion(player, packetObj, suggestions, filteredTabCompletionEvent);
    }

    private boolean handleUnmodifiableTabCompletion(Player player, Object packetObj, Suggestions suggestions, FilteredTabCompletionEvent filteredTabCompletionEvent) {
        ArrayList<Suggestion> filteredSuggestionsList = new ArrayList<Suggestion>();
        if (!filteredTabCompletionEvent.isCancelled()) {
            for (Suggestion suggestion : suggestions.getList()) {
                if (!filteredTabCompletionEvent.getCompletion().contains(suggestion.getText())) continue;
                filteredSuggestionsList.add(suggestion);
            }
        }
        Suggestions filteredSuggestions = new Suggestions(suggestions.getRange(), filteredSuggestionsList);
        try {
            int val = -1;
            Method method = Reflection.getMethodByName(packetObj.getClass(), "e");
            if (method != null) {
                val = (Integer)method.invoke(packetObj, new Object[0]);
            }
            if (val == -1) {
                Logger.warning("Failed to read packet input!");
                return false;
            }
            Object packet = Reflection.getConstructor(packetObj.getClass(), Integer.TYPE, Suggestions.class).newInstance(val, filteredSuggestions);
            BukkitPacketAnalyzer.sendPacket(player.getUniqueId(), packet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private String getSuggestionFromEntry(Object suggestionObj) {
        try {
            List<Field> fields = Reflection.getFieldsByTypeNormal(suggestionObj.getClass(), "String", Reflection.SearchOption.ENDS);
            if (fields.isEmpty()) {
                return "";
            }
            Field field = fields.get(0);
            String result = (String)field.get(suggestionObj);
            field.setAccessible(false);
            return result;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return "";
        }
    }
}

