/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.netty.proxy;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.packet.AvailableCommandsPacket;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.TabCompleteRequestPacket;
import com.velocitypowered.proxy.protocol.packet.TabCompleteResponsePacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.UnsignedPlayerCommandPacket;
import de.rayzs.pat.api.brand.CustomServerBrand;
import de.rayzs.pat.api.event.PATEventHandler;
import de.rayzs.pat.api.event.events.FilteredTabCompletionEvent;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.VelocityLoader;
import de.rayzs.pat.plugin.listeners.velocity.VelocityBlockCommandListener;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.CommandsCache;
import de.rayzs.pat.utils.PacketUtils;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.message.MessageTranslator;
import de.rayzs.pat.utils.permission.PermissionUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class VelocityPacketAnalyzer {
    public static final ConcurrentHashMap<Player, Channel> INJECTED_PLAYERS = new ConcurrentHashMap();
    private static final String PIPELINE_NAME = "pat-velocity-handler";
    private static final String HANDLER_NAME = "handler";
    private static final HashMap<Player, String> PLAYER_INPUT_CACHE = new HashMap();
    private static Class<?> minecraftConnectionClass;
    private static Class<?> connectedPlayerConnectionClass;
    private static Class<?> signedChatCommandPacketClass;

    public static void injectAll() {
        VelocityLoader.getServer().getAllPlayers().forEach(VelocityPacketAnalyzer::inject);
    }

    public static void uninjectAll() {
        ((ConcurrentHashMap.KeySetView)INJECTED_PLAYERS.keySet()).forEach(VelocityPacketAnalyzer::uninject);
        INJECTED_PLAYERS.clear();
    }

    public static boolean isInjected(Player player) {
        return INJECTED_PLAYERS.containsKey(player);
    }

    public static boolean inject(Player player) {
        if (connectedPlayerConnectionClass == null) {
            connectedPlayerConnectionClass = Reflection.getClass("com.velocitypowered.proxy.connection.client.ConnectedPlayer");
        }
        if (minecraftConnectionClass == null) {
            minecraftConnectionClass = Reflection.getClass("com.velocitypowered.proxy.connection.MinecraftConnection");
        }
        try {
            Object connectedPlayerObj = connectedPlayerConnectionClass.cast(player);
            Object minecraftConnectionObj = Reflection.getMethodsByName(connectedPlayerConnectionClass, "getConnection").get(0).invoke(connectedPlayerObj, new Object[0]);
            Channel channel = (Channel)Reflection.getMethodsByName(minecraftConnectionClass, "getChannel").get(0).invoke(minecraftConnectionObj, new Object[0]);
            if (channel == null) {
                Logger.warning("Failed to inject " + player.getUsername() + "! Channel is null.");
                return false;
            }
            if (channel.pipeline().names().contains(PIPELINE_NAME)) {
                VelocityPacketAnalyzer.uninject(player);
            }
            channel.pipeline().addBefore(HANDLER_NAME, PIPELINE_NAME, (ChannelHandler)new PacketDecoder(player));
            INJECTED_PLAYERS.put(player, channel);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        return true;
    }

    public static void uninject(Player player) {
        Channel channel;
        PLAYER_INPUT_CACHE.remove(player);
        if (INJECTED_PLAYERS.containsKey(player) && (channel = INJECTED_PLAYERS.get(player)) != null) {
            INJECTED_PLAYERS.remove(player);
            channel.eventLoop().submit(() -> {
                ChannelPipeline pipeline = channel.pipeline();
                if (pipeline.names().contains(PIPELINE_NAME)) {
                    pipeline.remove(PIPELINE_NAME);
                }
            });
        }
    }

    public static String getPlayerInput(Player player) {
        String input = PLAYER_INPUT_CACHE.get(player);
        PLAYER_INPUT_CACHE.remove(player);
        return input;
    }

    public static void insertPlayerInput(Player player, String text) {
        PLAYER_INPUT_CACHE.put(player, text.toLowerCase());
    }

    private static class PacketDecoder
    extends ChannelDuplexHandler {
        private final Player player;

        private PacketDecoder(Player player) {
            this.player = player;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            UnsignedPlayerCommandPacket unsignedPlayerCommandPacket;
            if (!(msg instanceof MinecraftPacket)) {
                super.channelRead(ctx, msg);
                return;
            }
            MinecraftPacket packet = (MinecraftPacket)msg;
            if (packet.getClass().getSimpleName().equals("SignedChatCommand")) {
                try {
                    Object signedChatCommandPacket;
                    Field commandField;
                    String command;
                    if (signedChatCommandPacketClass == null) {
                        signedChatCommandPacketClass = Class.forName("com.velocitypowered.proxy.crypto.SignedChatCommand");
                    }
                    if (!VelocityBlockCommandListener.handleCommand(this.player, command = (String)(commandField = (signedChatCommandPacket = signedChatCommandPacketClass.cast(packet)).getClass().getField("command")).get(signedChatCommandPacket)).getResult().isAllowed()) {
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (packet instanceof UnsignedPlayerCommandPacket && !VelocityBlockCommandListener.handleCommand(this.player, (unsignedPlayerCommandPacket = (UnsignedPlayerCommandPacket)packet).getCommand()).getResult().isAllowed()) {
                return;
            }
            if (packet instanceof TabCompleteRequestPacket) {
                TabCompleteRequestPacket request = (TabCompleteRequestPacket)msg;
                if (request.getCommand() != null) {
                    if (Storage.ConfigSections.Settings.PATCH_EXPLOITS.isMalicious(request.getCommand())) {
                        MessageTranslator.send((Object)VelocityLoader.getServer().getConsoleCommandSource(), Storage.ConfigSections.Settings.PATCH_EXPLOITS.ALERT_MESSAGE.get().replace("%player%", this.player.getUsername()), new String[0]);
                        this.player.disconnect((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(Storage.ConfigSections.Settings.PATCH_EXPLOITS.KICK_MESSAGE.get()));
                    } else {
                        VelocityPacketAnalyzer.insertPlayerInput(this.player, request.getCommand());
                        super.channelRead(ctx, msg);
                    }
                }
            } else {
                super.channelRead(ctx, msg);
            }
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            AvailableCommandsPacket commands;
            if (!(msg instanceof MinecraftPacket)) {
                super.write(ctx, msg, promise);
                return;
            }
            MinecraftPacket packet = (MinecraftPacket)msg;
            if (packet instanceof PluginMessagePacket) {
                PluginMessagePacket pluginMessagePacket = (PluginMessagePacket)packet;
                if (CustomServerBrand.isEnabled() && CustomServerBrand.isBrandTag(pluginMessagePacket.getChannel()) && !this.player.getCurrentServer().isPresent()) {
                    PacketUtils.BrandManipulate brandManipulatePacket = CustomServerBrand.createBrandPacket(this.player);
                    super.write(ctx, (Object)new PluginMessagePacket(pluginMessagePacket.getChannel(), brandManipulatePacket.getByteBuf()), promise);
                    return;
                }
            } else if (packet instanceof TabCompleteResponsePacket) {
                if (!PermissionUtil.hasBypassPermission(this.player) && this.player.getCurrentServer().isPresent()) {
                    String cursor;
                    String[] split;
                    String playerInput;
                    TabCompleteResponsePacket response = (TabCompleteResponsePacket)packet;
                    boolean cancelsBeforeHand = false;
                    String rawPlayerInput = playerInput = VelocityPacketAnalyzer.getPlayerInput(this.player);
                    String server = ((ServerConnection)this.player.getCurrentServer().get()).getServerInfo().getName();
                    int spaces = 0;
                    if (playerInput.contains(" ") && (spaces = (split = playerInput.split(" ")).length) > 0) {
                        playerInput = split[0];
                    }
                    if (!playerInput.equals("/")) {
                        boolean bl = cancelsBeforeHand = !Storage.Blacklist.canPlayerAccessTab(this.player, StringUtils.replaceFirst(playerInput, "/", ""), server);
                        if (!cancelsBeforeHand) {
                            boolean bl2 = cancelsBeforeHand = Storage.ConfigSections.Settings.CUSTOM_VERSION.isTabCompletable(StringUtils.replaceFirst(playerInput, "/", "")) || Storage.ConfigSections.Settings.CUSTOM_PLUGIN.isTabCompletable(StringUtils.replaceFirst(playerInput, "/", ""));
                        }
                    }
                    if (!(cursor = playerInput).startsWith("/") && spaces < 2 && this.player.getProtocolVersion().getProtocol() >= 754) {
                        Logger.debug("Player won't receive TabCompleteResponsePacket because the client protocol id is " + this.player.getProtocolVersion().getProtocol() + "! This doesn't makes sense, that's why.");
                        return;
                    }
                    if (cursor.startsWith("/")) {
                        if (spaces == 0) {
                            response.getOffers().removeIf(offer -> {
                                String command = offer.getText();
                                if (command.startsWith("/")) {
                                    command = StringUtils.replaceFirst(command, "/", "");
                                }
                                return !Storage.Blacklist.canPlayerAccessTab(this.player, command, ((ServerConnection)this.player.getCurrentServer().get()).getServerInfo().getName());
                            });
                        } else {
                            if (cancelsBeforeHand) {
                                return;
                            }
                            ArrayList<String> suggestionsAsString = new ArrayList<String>();
                            response.getOffers().forEach(offer -> suggestionsAsString.add(offer.getText()));
                            FilteredTabCompletionEvent filteredTabCompletionEvent = PATEventHandler.callFilteredTabCompletionEvents(this.player.getUniqueId(), rawPlayerInput, suggestionsAsString);
                            if (filteredTabCompletionEvent.isCancelled()) {
                                return;
                            }
                            response.getOffers().removeIf(offer -> !filteredTabCompletionEvent.getCompletion().contains(offer.getText()));
                            if (response.getOffers().isEmpty()) {
                                return;
                            }
                        }
                    }
                }
            } else if (packet instanceof AvailableCommandsPacket && !PermissionUtil.hasBypassPermission(this.player) && this.player.getCurrentServer().isPresent() && !(commands = (AvailableCommandsPacket)packet).getRootNode().getChildren().isEmpty()) {
                String serverName = ((ServerConnection)this.player.getCurrentServer().get()).getServer().getServerInfo().getName();
                HashMap<String, CommandsCache> cache = Storage.getLoader().getCommandsCacheMap();
                if (!cache.containsKey(serverName)) {
                    cache.put(serverName, new CommandsCache());
                }
                CommandsCache commandsCache = (CommandsCache)cache.get(serverName);
                ArrayList<String> commandsAsString = new ArrayList<String>();
                commands.getRootNode().getChildren().stream().filter(command -> command != null && command.getName() != null).forEach(command -> commandsAsString.add(command.getName()));
                commandsCache.handleCommands(commandsAsString, serverName);
                if (PermissionUtil.hasBypassPermission(this.player)) {
                    return;
                }
                boolean newer = this.player.getProtocolVersion().getProtocol() > 340;
                List<String> playerCommands = commandsCache.getPlayerCommands(commandsAsString, this.player, this.player.getUniqueId(), serverName);
                if (commands.getRootNode().getChildren().size() == 1 && newer && commands.getRootNode().getChild("args") != null && commands.getRootNode().getChild("args").getChildren().isEmpty()) {
                    super.write(ctx, msg, promise);
                    return;
                }
                commands.getRootNode().getChildren().removeIf(command -> {
                    if (command == null || command.getName() == null) {
                        return true;
                    }
                    if (command.getName().equals("args")) {
                        return false;
                    }
                    return !playerCommands.contains(command.getName());
                });
            }
            super.write(ctx, msg, promise);
        }
    }
}

