/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.storage.storages;

import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.api.storage.StorageTemplate;
import de.rayzs.pat.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BlacklistStorage
extends StorageTemplate
implements Serializable {
    private List<String> commands = new ArrayList<String>();

    public BlacklistStorage(String navigatePath) {
        super(Storage.Files.STORAGE, navigatePath);
    }

    public boolean isListed(String command) {
        return this.isListed(command, !Storage.ConfigSections.Settings.TURN_BLACKLIST_TO_WHITELIST.ENABLED);
    }

    public boolean isListed(String command, boolean ignoreCollons) {
        if (this.commands == null) {
            return false;
        }
        if (this.commands.contains("*")) {
            return true;
        }
        for (String listedCommand : this.commands) {
            if (listedCommand == null) continue;
            if (ignoreCollons && (command = StringUtils.getFirstArg(command)).contains(":")) {
                command = command.substring(command.indexOf(58));
            }
            if (!StringUtils.getFirstArg(listedCommand).equalsIgnoreCase(StringUtils.getFirstArg(command))) continue;
            return true;
        }
        return false;
    }

    public void setList(List<String> commands) {
        this.commands = commands;
    }

    public BlacklistStorage add(String command) {
        if (!this.commands.contains(command)) {
            this.commands.add(command);
        }
        return this;
    }

    public BlacklistStorage remove(String command) {
        this.commands.remove(command);
        return this;
    }

    public BlacklistStorage clear() {
        this.commands.clear();
        return this;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    @Override
    public void save() {
        this.getConfig().setAndSave(this.getNavigatePath(), this.commands);
    }

    @Override
    public void load() {
        this.getConfig().reload();
        this.commands = (ArrayList)this.getConfig().getOrSet(this.getNavigatePath(), this.commands);
    }
}

