/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.storage.storages;

import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.api.storage.StorageTemplate;
import de.rayzs.pat.utils.Reflection;
import java.util.ArrayList;
import java.util.List;

public class IgnoredServersStorage
extends StorageTemplate {
    private List<String> servers = new ArrayList<String>();

    public IgnoredServersStorage(String navigatePath) {
        super(Storage.Files.STORAGE, navigatePath);
    }

    public IgnoredServersStorage add(String server) {
        if (!this.servers.contains(server = server.toLowerCase())) {
            this.servers.add(server);
        }
        return this;
    }

    public IgnoredServersStorage remove(String server) {
        server = server.toLowerCase();
        this.servers.remove(server);
        return this;
    }

    public boolean isListed(String server) {
        if (this.servers.isEmpty()) {
            return false;
        }
        return Storage.isServer(server, this.servers);
    }

    public boolean isListEmpty() {
        return this.servers.isEmpty();
    }

    @Override
    public void save() {
        this.getConfig().save();
    }

    @Override
    public void load() {
        if (!Reflection.isProxyServer()) {
            return;
        }
        this.getConfig().reload();
        this.servers = (ArrayList)this.getConfig().getOrSet(this.getNavigatePath(), this.servers);
    }
}

