/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin;

import de.rayzs.pat.api.brand.CustomServerBrand;
import de.rayzs.pat.api.communication.Communicator;
import de.rayzs.pat.api.netty.proxy.BungeePacketAnalyzer;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.PluginLoader;
import de.rayzs.pat.plugin.commands.BungeeCommand;
import de.rayzs.pat.plugin.listeners.bungee.BungeeAntiTabListener;
import de.rayzs.pat.plugin.listeners.bungee.BungeeBlockCommandListener;
import de.rayzs.pat.plugin.listeners.bungee.BungeePingListener;
import de.rayzs.pat.plugin.listeners.bungee.BungeePlayerConnectionListener;
import de.rayzs.pat.plugin.listeners.bungee.WaterfallAntiTabListener;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.plugin.metrics.bStats;
import de.rayzs.pat.plugin.modules.SubArgsModule;
import de.rayzs.pat.plugin.process.CommandProcess;
import de.rayzs.pat.utils.CommandsCache;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.VersionComparer;
import de.rayzs.pat.utils.adapter.LuckPermsAdapter;
import de.rayzs.pat.utils.configuration.Configurator;
import de.rayzs.pat.utils.configuration.updater.ConfigUpdater;
import de.rayzs.pat.utils.group.GroupManager;
import de.rayzs.pat.utils.message.MessageTranslator;
import de.rayzs.pat.utils.response.action.ActionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.api.scheduler.ScheduledTask;

public class BungeeLoader
extends Plugin
implements PluginLoader {
    private ScheduledTask updaterTask;
    private static Plugin plugin;
    private static java.util.logging.Logger logger;
    private static boolean checkUpdate;
    private static final HashMap<String, CommandsCache> commandsCacheMap;

    public void onLoad() {
        Configurator.createResourcedFile("files\\proxy-config.yml", "config.yml", false);
        Configurator.createResourcedFile("files\\proxy-storage.yml", "storage.yml", false);
        Configurator.createResourcedFile("files\\proxy-placeholders.yml", "placeholders.yml", false);
        Configurator.createResourcedFile("files\\proxy-custom-responses.yml", "custom-responses.yml", false);
    }

    public void onEnable() {
        plugin = this;
        logger = this.getLogger();
        CommandProcess.initialize();
        Reflection.initialize(this.getProxy());
        ConfigUpdater.initialize();
        Storage.USE_SIMPLECLOUD = Reflection.doesClassExist("eu.thesimplecloud.plugin.startup.CloudPlugin");
        Storage.initialize(this, this.getDescription().getVersion());
        VersionComparer.get().setCurrentVersion(Storage.CURRENT_VERSION);
        Storage.loadAll(true);
        MessageTranslator.initialize();
        CustomServerBrand.initialize();
        GroupManager.initialize();
        bStats.initialize(this);
        PluginManager manager = ProxyServer.getInstance().getPluginManager();
        BungeeLoader.registerCommand("bungeeproantitab", "bpat");
        manager.registerListener((Plugin)this, (Listener)new BungeePlayerConnectionListener());
        manager.registerListener((Plugin)this, (Listener)new BungeeAntiTabListener());
        manager.registerListener((Plugin)this, (Listener)new BungeeBlockCommandListener());
        manager.registerListener((Plugin)this, (Listener)new BungeePingListener());
        if (Reflection.isPaper()) {
            manager.registerListener((Plugin)this, (Listener)new WaterfallAntiTabListener());
        }
        this.startUpdaterTask();
        if (!Storage.ConfigSections.Settings.DISABLE_SYNC.DISABLED) {
            ProxyServer.getInstance().getScheduler().schedule((Plugin)this, Communicator::syncData, 5L, TimeUnit.SECONDS);
        }
        Storage.PLUGIN_OBJECT = this;
        if (manager.getPlugin("LuckPerms") != null) {
            LuckPermsAdapter.initialize();
        }
        if (manager.getPlugin("PAPIProxyBridge") != null) {
            Storage.USE_PAPIPROXYBRIDGE = true;
            Logger.info("Successfully hooked into PAPIProxyBridge!");
        }
        if (Storage.USE_SIMPLECLOUD) {
            Logger.warning("Detected SimpleCloud and therefore MiniMessages by Kyori are disabled!");
        }
        BungeePacketAnalyzer.injectAll();
        ConfigUpdater.broadcastMissingParts();
        ActionHandler.initialize();
        SubArgsModule.initialize();
    }

    public void onDisable() {
        BungeePacketAnalyzer.uninjectAll();
        MessageTranslator.closeAudiences();
    }

    private static void registerCommand(String ... commands) {
        for (String commandName : commands) {
            BungeeCommand command = new BungeeCommand(commandName);
            ProxyServer.getInstance().getPluginManager().registerCommand(plugin, (Command)command);
        }
    }

    @Override
    public Object getConsoleSender() {
        return ProxyServer.getInstance().getConsole();
    }

    @Override
    public Object getPlayerObjByName(String name) {
        return plugin.getProxy().getPlayer(name);
    }

    @Override
    public Object getPlayerObjByUUID(UUID uuid) {
        return plugin.getProxy().getPlayer(uuid);
    }

    @Override
    public HashMap<String, CommandsCache> getCommandsCacheMap() {
        return commandsCacheMap;
    }

    @Override
    public void updateCommandCache() {
        new ArrayList<CommandsCache>(commandsCacheMap.values()).forEach(CommandsCache::reset);
    }

    @Override
    public String getPlayerServerName(UUID uuid) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player == null || player.getServer() == null || player.getServer().getInfo() == null) {
            return null;
        }
        return player.getServer().getInfo().getName();
    }

    @Override
    public List<UUID> getPlayerIds() {
        return new ArrayList<UUID>(ProxyServer.getInstance().getPlayers().stream().map(ProxiedPlayer::getUniqueId).toList());
    }

    @Override
    public List<UUID> getPlayerIdsByServer(String server) {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        this.getServerNames().stream().filter(serverName -> Storage.isServer(server, serverName)).forEach(serverName -> {
            ServerInfo serverInfo = ProxyServer.getInstance().getServerInfo(serverName);
            if (serverInfo == null) {
                return;
            }
            uuids.addAll(serverInfo.getPlayers().stream().map(ProxiedPlayer::getUniqueId).toList());
        });
        return uuids;
    }

    @Override
    public List<String> getOnlinePlayerNames(String serverName) {
        return new ArrayList<String>(ProxyServer.getInstance().getPlayers().stream().filter(player -> {
            if (player == null || player.getServer() == null || player.getServer().getInfo() == null) {
                return false;
            }
            return player.getServer().getInfo().getName().equalsIgnoreCase(serverName);
        }).map(CommandSender::getName).toList());
    }

    @Override
    public boolean isPlayerOnline(String playerName) {
        return ProxyServer.getInstance().getPlayer(playerName) != null;
    }

    @Override
    public boolean doesPlayerExist(String playerName) {
        return this.isPlayerOnline(playerName);
    }

    @Override
    public List<String> getOnlinePlayerNames() {
        return new ArrayList<String>(ProxyServer.getInstance().getPlayers().stream().map(CommandSender::getName).toList());
    }

    @Override
    public List<String> getOfflinePlayerNames() {
        return new ArrayList<String>(ProxyServer.getInstance().getPlayers().stream().map(CommandSender::getName).toList());
    }

    @Override
    public List<String> getPlayerNames() {
        return new ArrayList<String>(ProxyServer.getInstance().getPlayers().stream().map(CommandSender::getName).toList());
    }

    @Override
    public String getNameByUUID(UUID uuid) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        return player != null ? player.getName() : "";
    }

    @Override
    public UUID getUUIDByName(String playerName) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(playerName);
        return player != null ? player.getUniqueId() : null;
    }

    @Override
    public List<String> getServerNames() {
        return new ArrayList<String>(ProxyServer.getInstance().getServers().keySet().stream().toList());
    }

    public void startUpdaterTask() {
        if (!Storage.ConfigSections.Settings.UPDATE.ENABLED) {
            return;
        }
        this.updaterTask = this.getProxy().getScheduler().schedule((Plugin)this, () -> {
            if (VersionComparer.get().computeComparison()) {
                this.getProxy().getScheduler().cancel(this.updaterTask);
            }
        }, 20L, (long)Storage.ConfigSections.Settings.UPDATE.PERIOD, TimeUnit.MILLISECONDS);
    }

    public static String getServerNameByPlayerUUID(UUID uuid) {
        ProxiedPlayer proxiedPlayer = ProxyServer.getInstance().getPlayer(uuid);
        if (proxiedPlayer == null) {
            return null;
        }
        Server server = proxiedPlayer.getServer();
        if (server == null) {
            return null;
        }
        ServerInfo serverInfo = server.getInfo();
        if (serverInfo == null) {
            return null;
        }
        return serverInfo.getName();
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static java.util.logging.Logger getPluginLogger() {
        return logger;
    }

    static {
        checkUpdate = false;
        commandsCacheMap = new HashMap();
    }
}

