/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin.listeners.bukkit;

import de.rayzs.pat.api.event.PATEventHandler;
import de.rayzs.pat.api.event.events.ExecuteCommandEvent;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.message.MessageTranslator;
import de.rayzs.pat.utils.permission.PermissionUtil;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class BukkitBlockCommandListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onUnknownCommandRecognition(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        String rawCommand = StringUtils.getFirstArg(event.getMessage());
        String command = rawCommand.substring(1);
        if (!Storage.ConfigSections.Settings.CUSTOM_UNKNOWN_COMMAND.ENABLED || event.isCancelled()) {
            return;
        }
        if (PermissionUtil.hasBypassPermission(player)) {
            return;
        }
        if (Bukkit.getHelpMap().getHelpTopic(rawCommand) != null) {
            return;
        }
        event.setCancelled(true);
        MessageTranslator.send((Object)player, Storage.ConfigSections.Settings.CUSTOM_UNKNOWN_COMMAND.MESSAGE, "%command%", command, "%world%", world.getName());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandProcess(PlayerCommandPreprocessEvent event) {
        ExecuteCommandEvent executeCommandEvent;
        Player player = event.getPlayer();
        if (Storage.ConfigSections.Settings.AUTO_LOWERCASE_COMMANDS.isCommand(StringUtils.getFirstArg(event.getMessage()))) {
            String command = event.getMessage();
            if (command.contains(" ")) {
                CharSequence[] args = command.split(" ");
                args[0] = args[0].toLowerCase();
                command = String.join((CharSequence)" ", args);
            } else {
                command = command.toLowerCase();
            }
            player.chat(command);
            event.setCancelled(true);
            return;
        }
        World world = player.getWorld();
        String command = event.getMessage();
        String worldName = world.getName();
        boolean bypassPermission = PermissionUtil.hasBypassPermission(player, command);
        command = command.substring(1);
        String displayName = command = StringUtils.getFirstArg(command);
        command = StringUtils.replaceTriggers(command, "", "\\", "<", ">", "&");
        command = command.toLowerCase();
        List<String> notificationMessage = MessageTranslator.replaceMessageList(Storage.ConfigSections.Messages.NOTIFICATION.ALERT, "%player%", player.getName(), "%command%", displayName, "%world%", worldName);
        if (bypassPermission) {
            return;
        }
        if (!Storage.ConfigSections.Settings.CANCEL_COMMAND.ENABLED) {
            return;
        }
        if (Storage.ConfigSections.Settings.HANDLE_THROUGH_PROXY.ENABLED) {
            return;
        }
        if (!Storage.Blacklist.canPlayerAccessChat(player, command)) {
            executeCommandEvent = PATEventHandler.callExecuteCommandEvents(player, event.getMessage(), true, !Storage.ConfigSections.Settings.TURN_BLACKLIST_TO_WHITELIST.ENABLED);
            if (executeCommandEvent.isBlocked()) {
                event.setCancelled(true);
                if (!executeCommandEvent.doesNotify()) {
                    return;
                }
                if (Storage.SEND_CONSOLE_NOTIFICATION) {
                    Logger.info(notificationMessage);
                }
                Storage.NOTIFY_PLAYERS.stream().filter(uuid -> Bukkit.getServer().getPlayer(uuid) != null).forEach(uuid -> {
                    Player target = Bukkit.getServer().getPlayer(uuid);
                    MessageTranslator.send((Object)target, notificationMessage);
                });
            }
            if (executeCommandEvent.isCancelled()) {
                return;
            }
        }
        if ((executeCommandEvent = PATEventHandler.callExecuteCommandEvents(player, event.getMessage(), false, false)).isBlocked()) {
            event.setCancelled(true);
        }
    }
}

