/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin.listeners.bungee;

import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.BungeeLoader;
import de.rayzs.pat.plugin.logger.Logger;
import java.util.ArrayList;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class BungeePingListener
implements Listener {
    @EventHandler(priority=-64)
    public void onProxyPing(ProxyPingEvent event) {
        if (!Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.ENABLED) {
            return;
        }
        ProxyServer proxyServer = BungeeLoader.getPlugin().getProxy();
        int online = proxyServer.getOnlineCount();
        int onlineExtend = online + Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.EXTEND_COUNT;
        int max = -1;
        try {
            max = ((ListenerInfo)proxyServer.getConfigurationAdapter().getListeners().iterator().next()).getMaxPlayers();
        }
        catch (Throwable throwable) {
            Logger.debug("Failed to read max-players count for %max% placeholder! Using -1 as default value instead.");
        }
        ServerPing serverPing = event.getResponse();
        int protocol = Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.ALWAYS_SHOW ? -1 : serverPing.getVersion().getProtocol();
        String version = this.replaceString(Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.PROTOCOL, online, onlineExtend, max);
        ServerPing.Protocol newProtocol = new ServerPing.Protocol(version, protocol);
        serverPing.setVersion(newProtocol);
        if (Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.USE_EXTEND_AS_MAX_COUNT) {
            serverPing.getPlayers().setMax(onlineExtend);
        }
        if (Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.HIDE_PLAYERS) {
            serverPing.getPlayers().setSample(new ServerPing.PlayerInfo[0]);
        } else if (Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.USE_CUSTOM_PLAYERLIST) {
            ArrayList<String> lines = Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.PLAYERLIST.getLines();
            ServerPing.PlayerInfo[] playerInfos = new ServerPing.PlayerInfo[lines.size()];
            for (int i = 0; i < lines.size(); ++i) {
                playerInfos[i] = new ServerPing.PlayerInfo(this.replaceString((String)lines.get(i), online, onlineExtend, max), "");
            }
            serverPing.getPlayers().setSample(playerInfos);
        }
        event.setResponse(serverPing);
    }

    private String replaceString(String string, int online, int onlineExtend, int max) {
        return string.replace("&", "\u00a7").replace("%online_extended%", String.valueOf(onlineExtend)).replace("%online%", String.valueOf(online)).replace("%max%", String.valueOf(max));
    }
}

