/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin.process;

import de.rayzs.pat.api.command.ProCommand;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.process.impl.local.info.InfoCommand;
import de.rayzs.pat.plugin.process.impl.local.info.PermsCommand;
import de.rayzs.pat.plugin.process.impl.local.info.StatsCommand;
import de.rayzs.pat.plugin.process.impl.local.info.UpdateCommand;
import de.rayzs.pat.plugin.process.impl.local.modify.AddCommand;
import de.rayzs.pat.plugin.process.impl.local.modify.ClearCommand;
import de.rayzs.pat.plugin.process.impl.local.modify.CreateGroupCommand;
import de.rayzs.pat.plugin.process.impl.local.modify.DeleteGroupCommand;
import de.rayzs.pat.plugin.process.impl.local.modify.RemoveCommand;
import de.rayzs.pat.plugin.process.impl.local.modify.SetPriorityCommand;
import de.rayzs.pat.plugin.process.impl.local.modify.list.ListCommand;
import de.rayzs.pat.plugin.process.impl.local.modify.list.ListGroupsCommand;
import de.rayzs.pat.plugin.process.impl.local.modify.list.ListPrioritiesCommand;
import de.rayzs.pat.plugin.process.impl.local.system.NotifyCommand;
import de.rayzs.pat.plugin.process.impl.local.system.PostDebugCommand;
import de.rayzs.pat.plugin.process.impl.local.system.ReloadCommand;
import de.rayzs.pat.plugin.process.impl.server.ServAddCommand;
import de.rayzs.pat.plugin.process.impl.server.ServClearCommand;
import de.rayzs.pat.plugin.process.impl.server.ServRemoveCommand;
import de.rayzs.pat.plugin.process.impl.server.list.ServListCommand;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.permission.PermissionUtil;
import de.rayzs.pat.utils.sender.CommandSender;
import de.rayzs.pat.utils.sender.CommandSenderHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CommandProcess {
    private static final List<ProCommand> COMMANDS = new ArrayList<ProCommand>();

    public static void initialize() {
        COMMANDS.add(new SetPriorityCommand());
        COMMANDS.add(new NotifyCommand());
        COMMANDS.add(new AddCommand());
        COMMANDS.add(new RemoveCommand());
        COMMANDS.add(new ClearCommand());
        COMMANDS.add(new CreateGroupCommand());
        COMMANDS.add(new DeleteGroupCommand());
        COMMANDS.add(new ListCommand());
        COMMANDS.add(new ListGroupsCommand());
        COMMANDS.add(new ListPrioritiesCommand());
        COMMANDS.add(new StatsCommand());
        COMMANDS.add(new InfoCommand());
        COMMANDS.add(new PermsCommand());
        COMMANDS.add(new PostDebugCommand());
        COMMANDS.add(new UpdateCommand());
        COMMANDS.add(new ReloadCommand());
        COMMANDS.add(new ServListCommand());
        COMMANDS.add(new ServAddCommand());
        COMMANDS.add(new ServRemoveCommand());
        COMMANDS.add(new ServClearCommand());
    }

    public static void handleCommand(Object senderObj, String[] args, String label) {
        Optional<ProCommand> optCommand;
        CommandSender sender = CommandSenderHandler.from(senderObj);
        if (!PermissionUtil.hasPermissionWithResponse(sender, "use")) {
            return;
        }
        if (args.length == 0) {
            Storage.ConfigSections.Messages.HELP.MESSAGE.getLines().forEach(line -> sender.sendMessage(line.replace("%label%", label)));
            return;
        }
        String commandName = args[0];
        String[] commandArgs = new String[]{};
        if (commandName.equals("serv") || commandName.equals("server")) {
            Optional<ProCommand> optCommand2;
            if (args.length < 2) {
                sender.sendMessage(Storage.ConfigSections.Messages.COMMAND_FAILED.MESSAGE);
                return;
            }
            String servCommandName = StringUtils.getFirstArg(args[1]);
            if (args.length > 2) {
                commandArgs = Arrays.copyOfRange(args, 2, args.length);
            }
            if ((optCommand2 = COMMANDS.stream().filter(cmd -> {
                if (Reflection.isProxyServer() && cmd.isServerCommand()) {
                    return cmd.isCommand(servCommandName);
                }
                return false;
            }).findFirst()).isEmpty()) {
                sender.sendMessage(Storage.ConfigSections.Messages.COMMAND_FAILED.MESSAGE);
                return;
            }
            ProCommand command = optCommand2.get();
            if (!PermissionUtil.hasPermissionWithResponse(sender, command.getName())) {
                return;
            }
            if (!command.execute(sender, commandArgs)) {
                sender.sendMessage(Storage.ConfigSections.Messages.COMMAND_FAILED.MESSAGE);
            }
            return;
        }
        if (args.length > 1) {
            commandArgs = Arrays.copyOfRange(args, 1, args.length);
        }
        if ((optCommand = COMMANDS.stream().filter(cmd -> {
            if (!Reflection.isProxyServer() && !cmd.isProxyOnly() || Reflection.isProxyServer() && !cmd.isServerCommand()) {
                return cmd.isCommand(commandName);
            }
            return false;
        }).findFirst()).isEmpty()) {
            sender.sendMessage(Storage.ConfigSections.Messages.COMMAND_FAILED.MESSAGE);
            return;
        }
        ProCommand command = optCommand.get();
        if (!PermissionUtil.hasPermissionWithResponse(sender, command.getName())) {
            return;
        }
        if (!command.execute(sender, commandArgs)) {
            sender.sendMessage(Storage.ConfigSections.Messages.COMMAND_FAILED.MESSAGE);
        }
    }

    public static List<String> handleTabComplete(Object senderObj, String[] args) {
        CommandSender sender = CommandSenderHandler.from(senderObj);
        ArrayList<String> result = new ArrayList<String>();
        if (!PermissionUtil.hasPermission(sender, "use")) {
            return result;
        }
        if (args.length <= 1) {
            if (Reflection.isProxyServer()) {
                result.addAll(Arrays.asList("serv", "server"));
            }
            COMMANDS.stream().filter(cmd -> {
                if (!Reflection.isProxyServer() && cmd.isProxyOnly()) {
                    return false;
                }
                return PermissionUtil.hasPermission(sender, cmd.getName());
            }).forEach(cmd -> {
                result.add(cmd.getName());
                result.addAll(cmd.getAliases());
            });
        } else {
            ProCommand command;
            Optional<ProCommand> optCommand;
            String[] commandArgs;
            String commandName = StringUtils.getFirstArg(args[0]);
            if (commandName.equals("serv") || commandName.equals("server")) {
                if (args.length == 2) {
                    COMMANDS.stream().filter(cmd -> {
                        if (Reflection.isProxyServer() && cmd.isServerCommand()) {
                            return PermissionUtil.hasPermission(sender, cmd.getName());
                        }
                        return false;
                    }).forEach(cmd -> {
                        result.add(cmd.getName());
                        result.addAll(cmd.getAliases());
                    });
                    return result;
                }
                String servCommandName = StringUtils.getFirstArg(args[1]);
                commandArgs = Arrays.copyOfRange(args, 2, args.length);
                if (commandArgs.length == 1 && commandArgs[0].isBlank()) {
                    commandArgs = new String[]{};
                }
                optCommand = COMMANDS.stream().filter(cmd -> {
                    if (Reflection.isProxyServer() && cmd.isServerCommand()) {
                        return cmd.isCommand(servCommandName) && PermissionUtil.hasPermission(sender, cmd.getName());
                    }
                    return false;
                }).findFirst();
            } else {
                commandArgs = Arrays.copyOfRange(args, 1, args.length);
                if (commandArgs.length == 1 && commandArgs[0].isBlank()) {
                    commandArgs = new String[]{};
                }
                optCommand = COMMANDS.stream().filter(cmd -> {
                    if (!Reflection.isProxyServer() && cmd.isProxyOnly() || cmd.isServerCommand()) {
                        return false;
                    }
                    return cmd.isCommand(commandName);
                }).findFirst();
            }
            if (optCommand.isPresent() && PermissionUtil.hasPermission(sender, (command = optCommand.get()).getName())) {
                List<String> cmdCompletions = command.tabComplete(sender, commandArgs);
                result.addAll(cmdCompletions != null ? cmdCompletions : List.of());
            }
        }
        return result.stream().filter(suggestion -> {
            if (args.length == 0) {
                return true;
            }
            String command = args[Math.max(0, args.length - 1)].toLowerCase();
            suggestion = suggestion.toLowerCase();
            if (command.startsWith("\"")) {
                command = command.length() == 1 ? "" : command.substring(1);
            }
            return suggestion.startsWith(command);
        }).toList();
    }
}

