/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin.process.impl.local.modify;

import de.rayzs.pat.api.command.ProCommand;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.api.storage.blacklist.impl.GroupBlacklist;
import de.rayzs.pat.plugin.BukkitLoader;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.group.Group;
import de.rayzs.pat.utils.group.GroupManager;
import de.rayzs.pat.utils.sender.CommandSender;
import java.util.Arrays;
import java.util.List;

public class AddCommand
extends ProCommand {
    public AddCommand() {
        super("add", "");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        boolean backend;
        if (args.length == 0) {
            return false;
        }
        boolean bl = backend = Storage.ConfigSections.Settings.HANDLE_THROUGH_PROXY.ENABLED && !Reflection.isProxyServer();
        if (backend) {
            sender.sendMessage(Storage.ConfigSections.Messages.NO_PROXY.MESSAGE);
            return true;
        }
        String fullString = String.join((CharSequence)" ", args);
        String command = fullString;
        if (!command.startsWith("\"")) {
            command = args[0];
        } else {
            int lastIndex = (command = command.substring(1)).indexOf("\"");
            if (lastIndex == -1) {
                return false;
            }
            command = command.substring(0, lastIndex);
            fullString = fullString.replace("\"" + command + "\"", ":::");
            args = fullString.split(" ");
        }
        command = StringUtils.replaceTriggers(command, "", "\\.", "'", "\"");
        if (command.isEmpty()) {
            return false;
        }
        int length = args.length;
        if (length == 1) {
            boolean exist;
            boolean bl2 = exist = command.contains(" ") ? Storage.Blacklist.getBlacklist().getCommands().contains(command) : Storage.Blacklist.getBlacklist().isListed(command);
            if (!exist) {
                Storage.Blacklist.getBlacklist().add(command).save();
                Storage.handleChange();
            }
            String message = exist ? Storage.ConfigSections.Messages.BLACKLIST.ADD_FAILED : Storage.ConfigSections.Messages.BLACKLIST.ADD_SUCCESS;
            message = StringUtils.replace(message, "%command%", command);
            sender.sendMessage(message);
            return true;
        }
        String groupName = args[1];
        Group group = GroupManager.getGroupByName(groupName);
        if (group == null) {
            sender.sendMessage(Storage.ConfigSections.Messages.GROUP.DOES_NOT_EXIST.replace("%group%", groupName));
            return true;
        }
        GroupBlacklist blacklist = group.getGeneralGroupBlacklist();
        boolean exist = blacklist.getCommands().contains(command);
        if (!exist) {
            group.add(command);
            Storage.handleChange();
        }
        String message = exist ? Storage.ConfigSections.Messages.GROUP.ADD_FAILED : Storage.ConfigSections.Messages.GROUP.ADD_SUCCESS;
        message = StringUtils.replace(message, "%group%", groupName, "%command%", command);
        sender.sendMessage(message);
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        int length;
        String fullString;
        if (args.length == 0 || args.length == 1 && !args[0].startsWith("\"")) {
            if (Reflection.isProxyServer()) {
                return null;
            }
            return BukkitLoader.getNotBlockedCommands();
        }
        String command = fullString = String.join((CharSequence)" ", args);
        if (args[0].startsWith("\"")) {
            int lastIndex = (command = command.length() == 1 ? "" : command.substring(1, command.length() - 1)).indexOf("\"");
            if (lastIndex == -1) {
                return null;
            }
            command = command.substring(0, lastIndex);
            args = Arrays.copyOfRange(args, command.split(" ").length - 1, args.length);
        }
        return (length = args.length) == 2 ? GroupManager.getGroupNames() : null;
    }
}

