/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils;

import de.rayzs.pat.api.event.PATEventHandler;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.ArrayUtils;
import de.rayzs.pat.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class CommandsCache {
    private List<String> filteredCommands = null;
    private List<String> allCommands = null;
    private boolean change = false;

    public void handleCommands(List<String> commands) {
        if (this.change || !this.isOutdated(commands)) {
            return;
        }
        this.filteredCommands = new LinkedList<String>();
        this.allCommands = new ArrayList<String>(commands);
        for (String command : this.allCommands) {
            Storage.Blacklist.BlockType type = Storage.Blacklist.BlockTypeFetcher.getType(command = StringUtils.getFirstArg(command));
            if (type != Storage.Blacklist.BlockType.BOTH && type != Storage.Blacklist.BlockType.TAB || !this.isFilterListAvailable() || this.filteredCommands.contains(command) || Storage.Blacklist.isBlockedTab(command)) continue;
            this.filteredCommands.add(command);
        }
        this.change = true;
    }

    public void handleCommands(List<String> commands, String server) {
        if (!this.isOutdated(commands)) {
            return;
        }
        this.filteredCommands = new LinkedList<String>();
        this.allCommands = new ArrayList<String>(commands);
        for (String command : this.allCommands) {
            Storage.Blacklist.BlockType type = Storage.Blacklist.BlockTypeFetcher.getType(command = StringUtils.getFirstArg(command));
            if (type != Storage.Blacklist.BlockType.BOTH && type != Storage.Blacklist.BlockType.TAB || !this.isFilterListAvailable(server) || this.filteredCommands.contains(command) || Storage.Blacklist.isBlockedTab(command, server)) continue;
            this.filteredCommands.add(command);
        }
    }

    public List<String> getPlayerCommands(Collection<String> unfilteredCommands, Object targetObj, UUID uuid) {
        return this.getPlayerCommands(unfilteredCommands, targetObj, uuid, null);
    }

    public List<String> getPlayerCommands(Collection<String> unfilteredCommands, Object targetObj, UUID uuid, String serverName) {
        LinkedList<String> localFilteredCommands;
        LinkedList<String> playerCommands = new LinkedList<String>(unfilteredCommands);
        LinkedList<String> linkedList = localFilteredCommands = this.filteredCommands == null ? null : new LinkedList<String>(this.filteredCommands);
        if (localFilteredCommands == null) {
            return playerCommands;
        }
        boolean hasNamespaceBypass = Storage.ConfigSections.Settings.BLOCK_NAMESPACE_COMMANDS.doesBypass(targetObj);
        playerCommands.removeIf(command -> {
            if (!hasNamespaceBypass && Storage.ConfigSections.Settings.BLOCK_NAMESPACE_COMMANDS.isCommand((String)command)) {
                return true;
            }
            if (localFilteredCommands.contains(command)) {
                return false;
            }
            return !Storage.Blacklist.canPlayerAccessTab(targetObj, command, serverName);
        });
        String uuidSubstring = uuid.toString().substring(uuid.toString().length() - 5);
        if (playerCommands.isEmpty()) {
            Logger.debug("Commands list for player with uuid " + uuidSubstring + " is empty! (" + String.valueOf(this.filteredCommands != null ? Integer.valueOf(this.filteredCommands.size()) : "null") + " | " + String.valueOf(unfilteredCommands != null ? Integer.valueOf(unfilteredCommands.size()) : "null") + ")");
        } else {
            Logger.debug("Created list of commands for player with uuid " + uuidSubstring + " with a total of " + playerCommands.size() + " commands!");
        }
        PATEventHandler.callUpdatePlayerCommandsEvents(targetObj, playerCommands, serverName != null);
        return playerCommands.stream().map(command -> {
            Storage.Blacklist.BlockType type = Storage.Blacklist.BlockTypeFetcher.getType(command = StringUtils.getFirstArg(command));
            if (type == null || type == Storage.Blacklist.BlockType.BOTH) {
                return command;
            }
            return Storage.Blacklist.BlockTypeFetcher.modify(command, type);
        }).toList();
    }

    public boolean isFilterListAvailable() {
        return this.isFilterListAvailable(null);
    }

    public boolean isFilterListAvailable(String server) {
        boolean available;
        boolean bl = available = this.filteredCommands != null;
        if (!available) {
            Logger.debug("FilterList didn't exist during built!" + (String)(server != null ? "(server: " + server + ")" : ""));
        }
        return available;
    }

    public void updateChangeState() {
        this.change = false;
    }

    public void reset() {
        this.updateChangeState();
        this.filteredCommands = null;
    }

    public boolean isOutdated(List<String> commands) {
        return this.filteredCommands == null || !ArrayUtils.compareStringArrays(commands, this.allCommands);
    }
}

