/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils;

public class TimeConverter {
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int HOUR = 3600000;
    private static final int DAY = 86400000;
    private static final int WEEK = 604800000;

    public static String calcAndGetTime(long time) {
        long upTime = System.currentTimeMillis() - time;
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int ms = (int)upTime;
        while (ms >= 1000) {
            if (ms >= 604800000) {
                ++weeks;
                ms -= 604800000;
                continue;
            }
            if (ms >= 86400000) {
                ++days;
                ms -= 86400000;
                continue;
            }
            if (ms >= 3600000) {
                ++hours;
                ms -= 3600000;
                continue;
            }
            if (ms >= 60000) {
                ++minutes;
                ms -= 60000;
                continue;
            }
            if (++seconds >= 60) {
                seconds = 0;
                ++minutes;
            }
            ms -= 1000;
        }
        StringBuilder uptimeText = new StringBuilder();
        if (weeks > 0) {
            uptimeText.append(weeks + "w, ");
        } else if (days > 0) {
            uptimeText.append(days + "d, ");
        } else if (hours > 0) {
            uptimeText.append(hours + "h, ");
        } else if (minutes > 0) {
            uptimeText.append(minutes + "m, ");
        } else if (seconds > 0) {
            uptimeText.append(seconds + "s");
        } else {
            uptimeText.append(ms + "ms");
        }
        return uptimeText.toString();
    }
}

