/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.group;

import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.api.storage.blacklist.BlacklistCreator;
import de.rayzs.pat.api.storage.blacklist.impl.GroupBlacklist;
import de.rayzs.pat.utils.ExpireCache;
import de.rayzs.pat.utils.configuration.ConfigurationBuilder;
import de.rayzs.pat.utils.permission.PermissionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Group
implements Serializable {
    private final HashMap<String, GroupBlacklist> groupServerBlacklist = new HashMap();
    private final GroupBlacklist generalGroupBlacklist;
    private final ExpireCache<String, List<GroupBlacklist>> cachedServerGroupBlacklists = new ExpireCache(1L, TimeUnit.HOURS);
    private final String groupName;
    private int priority;

    public Group(String groupName) {
        this.groupName = groupName;
        this.priority = (Integer)Storage.Files.STORAGE.getOrSet("groups." + groupName + ".priority", 1);
        this.generalGroupBlacklist = BlacklistCreator.createGroupBlacklist(groupName);
        this.generalGroupBlacklist.load();
        this.loadServerBlacklist();
    }

    public Group(String groupName, int priority) {
        this.groupName = groupName;
        this.priority = priority;
        this.generalGroupBlacklist = BlacklistCreator.createGroupBlacklist(groupName);
        this.generalGroupBlacklist.load();
        this.loadServerBlacklist();
    }

    public Group(String groupName, List<String> commands) {
        this.groupName = groupName;
        this.priority = (Integer)Storage.Files.STORAGE.getOrSet("groups." + groupName + ".priority", 1);
        this.generalGroupBlacklist = BlacklistCreator.createGroupBlacklist(groupName);
        this.generalGroupBlacklist.setList(commands);
        this.loadServerBlacklist();
    }

    public Group(String groupName, int priority, List<String> commands) {
        this.groupName = groupName;
        this.priority = priority;
        this.generalGroupBlacklist = BlacklistCreator.createGroupBlacklist(groupName);
        this.generalGroupBlacklist.setList(commands);
        this.loadServerBlacklist();
    }

    private void loadServerBlacklist() {
        String path = "groups." + this.groupName + ".servers";
        if (Storage.Files.STORAGE.get(path) == null) {
            return;
        }
        Storage.Files.STORAGE.getKeys("groups." + this.groupName + ".servers", false).forEach(this::getOrCreateGroupBlacklist);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public GroupBlacklist getGeneralGroupBlacklist() {
        return this.generalGroupBlacklist;
    }

    public void add(String command) {
        this.generalGroupBlacklist.add(command).save();
    }

    public void add(String command, String server) {
        GroupBlacklist serverGroupBlacklist = this.getOrCreateGroupBlacklist(server, true);
        serverGroupBlacklist.load();
        serverGroupBlacklist.add(command).save();
    }

    public void remove(String command) {
        this.generalGroupBlacklist.remove(command).save();
    }

    public void remove(String command, String server) {
        GroupBlacklist serverGroupBlacklist = this.getOrCreateGroupBlacklist(server, true);
        serverGroupBlacklist.load();
        serverGroupBlacklist.remove(command).save();
    }

    public void clear() {
        this.generalGroupBlacklist.clear().save();
    }

    public void clear(String server) {
        GroupBlacklist serverGroupBlacklist = this.getOrCreateGroupBlacklist(server, true);
        serverGroupBlacklist.clear().save();
        serverGroupBlacklist.load();
        Storage.Files.STORAGE.reload();
    }

    public void setCommands(List<String> commands) {
        this.generalGroupBlacklist.setList(commands);
    }

    public void setPriority(int priority) {
        Storage.Files.STORAGE.setAndSave("groups." + this.groupName + ".priority", priority);
        this.priority = priority;
    }

    public boolean hasPermission(Object targetObj) {
        return PermissionUtil.hasPermission(targetObj, "group." + this.groupName);
    }

    public boolean contains(String command) {
        return this.contains(command, null);
    }

    public boolean contains(String command, String server) {
        if (this.generalGroupBlacklist.isListed(command)) {
            return true;
        }
        if (server == null) {
            return false;
        }
        GroupBlacklist groupBlacklist = this.getOrCreateGroupBlacklist(server);
        if (groupBlacklist != null) {
            return groupBlacklist.isListed(command);
        }
        return false;
    }

    public GroupBlacklist getOrCreateGroupBlacklist(String server) {
        return this.getOrCreateGroupBlacklist(server, false);
    }

    public GroupBlacklist getOrCreateGroupBlacklist(String server, boolean ignoreExist) {
        GroupBlacklist groupBlacklist;
        if (server == null) {
            return null;
        }
        if (this.groupServerBlacklist.containsKey(server) && this.groupServerBlacklist.get(server) != null) {
            groupBlacklist = this.groupServerBlacklist.get(server);
        } else {
            groupBlacklist = BlacklistCreator.createGroupBlacklist(this.groupName, server, ignoreExist);
            this.groupServerBlacklist.put(server, groupBlacklist);
        }
        if (groupBlacklist != null) {
            groupBlacklist.load();
        }
        return groupBlacklist;
    }

    public int getPriority() {
        return this.priority;
    }

    public void clearServerGroupBlacklistsCache() {
        this.cachedServerGroupBlacklists.clear();
    }

    public List<String> getBlacklistServerNames(String server) {
        return this.groupServerBlacklist.keySet().stream().filter(key -> Storage.isServer(key, server)).toList();
    }

    public List<GroupBlacklist> getAllServerGroupBlacklist(String server) {
        return this.getAllServerGroupBlacklist(server, false);
    }

    public List<GroupBlacklist> getAllServerGroupBlacklist(String server, boolean useDefault) {
        if (this.cachedServerGroupBlacklists.contains(server) && this.cachedServerGroupBlacklists.get(server).size() > (useDefault ? 1 : 0)) {
            return this.cachedServerGroupBlacklists.get(server);
        }
        ArrayList<GroupBlacklist> groupBlacklists = new ArrayList<GroupBlacklist>();
        if (useDefault) {
            groupBlacklists.add(this.generalGroupBlacklist);
        }
        for (String key : this.groupServerBlacklist.keySet()) {
            GroupBlacklist groupBlacklist;
            if (!Storage.isServer(key, server) || (groupBlacklist = this.groupServerBlacklist.get(key)) == null) continue;
            groupBlacklists.add(groupBlacklist);
        }
        return this.cachedServerGroupBlacklists.putAndGet(server, groupBlacklists);
    }

    public List<String> getCommands() {
        return this.generalGroupBlacklist.getCommands();
    }

    public List<String> getCommands(String server) {
        ArrayList<String> commands = new ArrayList<String>();
        GroupBlacklist groupBlacklist = this.getOrCreateGroupBlacklist(server);
        if (groupBlacklist != null) {
            commands.addAll(groupBlacklist.getCommands());
        }
        return commands;
    }

    public List<String> getAllCommands(String server) {
        ArrayList<String> commands = new ArrayList<String>(this.generalGroupBlacklist.getCommands());
        GroupBlacklist groupBlacklist = this.getOrCreateGroupBlacklist(server);
        if (groupBlacklist != null) {
            commands.addAll(groupBlacklist.getCommands());
        }
        return commands;
    }

    public void deleteGroup() {
        this.deleteGroup(null);
    }

    public void deleteGroup(String server) {
        String path = "groups." + this.groupName + (String)(server != null ? "." + server : "");
        Storage.Files.STORAGE.setAndSave(path, null);
        Storage.Files.STORAGE.reload();
    }

    public ConfigurationBuilder getConfig() {
        return this.generalGroupBlacklist.getConfig();
    }

    public void save() {
        this.generalGroupBlacklist.save();
    }
}

