/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.message;

import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.configuration.helper.MultipleMessagesHelper;
import de.rayzs.pat.utils.message.Translator;
import de.rayzs.pat.utils.message.replacer.PlaceholderReplacer;
import de.rayzs.pat.utils.message.translators.BukkitMessageTranslator;
import de.rayzs.pat.utils.message.translators.BungeeMessageTranslator;
import de.rayzs.pat.utils.message.translators.VelocityMessageTranslator;
import de.rayzs.pat.utils.sender.CommandSender;
import de.rayzs.pat.utils.sender.CommandSenderHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageTranslator {
    private static final HashMap<Character, String> colors = new HashMap();
    private static final HashMap<Character, String> endingColors = new HashMap();
    private static boolean support;
    private static Translator translator;

    public static void initialize() {
        colors.put(Character.valueOf('1'), "<dark_blue>");
        colors.put(Character.valueOf('2'), "<dark_green>");
        colors.put(Character.valueOf('3'), "<dark_aqua>");
        colors.put(Character.valueOf('4'), "<dark_red>");
        colors.put(Character.valueOf('5'), "<dark_purple>");
        colors.put(Character.valueOf('6'), "<gold>");
        colors.put(Character.valueOf('7'), "<gray>");
        colors.put(Character.valueOf('8'), "<dark_gray>");
        colors.put(Character.valueOf('9'), "<blue>");
        colors.put(Character.valueOf('a'), "<green>");
        colors.put(Character.valueOf('b'), "<aqua>");
        colors.put(Character.valueOf('c'), "<red>");
        colors.put(Character.valueOf('d'), "<light_purple>");
        colors.put(Character.valueOf('e'), "<yellow>");
        colors.put(Character.valueOf('f'), "<white>");
        colors.put(Character.valueOf('m'), "<st>");
        colors.put(Character.valueOf('k'), "<obf>");
        colors.put(Character.valueOf('r'), "<reset>");
        colors.put(Character.valueOf('o'), "<i>");
        colors.put(Character.valueOf('l'), "<b>");
        for (Map.Entry<Character, String> entry : colors.entrySet()) {
            endingColors.put(entry.getKey(), "</" + entry.getValue().substring(1));
        }
        boolean bl = support = !Storage.USE_SIMPLECLOUD && (Reflection.getMinor() >= 18 || Reflection.isProxyServer());
        if (support) {
            translator = Reflection.isVelocityServer() ? new VelocityMessageTranslator() : (Reflection.isProxyServer() ? new BungeeMessageTranslator() : new BukkitMessageTranslator());
        }
    }

    public static String translateLegacy(String text) {
        if (!(text = MessageTranslator.replaceMessage(text)).contains("\u00a7")) {
            return text;
        }
        for (Map.Entry<Character, String> entry : colors.entrySet()) {
            text = text.replace("\u00a7" + String.valueOf(entry.getKey()), entry.getValue());
        }
        return text;
    }

    public static String colorless(String text) {
        if (!(text = MessageTranslator.replaceMessage(text)).contains("\u00a7")) {
            return text;
        }
        for (Map.Entry<Character, String> entry : colors.entrySet()) {
            text = text.replace("\u00a7" + String.valueOf(entry.getKey()), "");
        }
        return text;
    }

    public static void send(Object target, MultipleMessagesHelper texts) {
        String stringList = StringUtils.getStringList(texts.getLines(), "\n");
        MessageTranslator.send(target, stringList, new String[0]);
    }

    public static void send(Object target, MultipleMessagesHelper texts, String ... replacements) {
        String stringList = StringUtils.getStringList(texts.getLines(), "\n");
        MessageTranslator.send(target, stringList, replacements);
    }

    public static void send(Object target, List<String> texts) {
        String stringList = StringUtils.getStringList(texts, "\n");
        MessageTranslator.send(target, stringList, new String[0]);
    }

    public static void send(Object target, List<String> texts, String ... replacements) {
        texts = MessageTranslator.replaceMessageList(texts, replacements);
        MessageTranslator.send(target, texts);
    }

    public static void send(Object target, String text, String ... replacements) {
        if (text.isEmpty()) {
            return;
        }
        if ((text = MessageTranslator.replaceMessageString(target, text, replacements)).contains("%no-message%")) {
            return;
        }
        if (translator == null) {
            CommandSender sender = target instanceof CommandSender ? (CommandSender)target : CommandSenderHandler.from(target);
            if (!PlaceholderReplacer.process(sender, text, sender::sendMessage)) {
                sender.sendMessage(text);
            }
            return;
        }
        if (PlaceholderReplacer.process(target, text, result -> translator.send(target, (String)result))) {
            return;
        }
        translator.send(target, text);
    }

    public static String replaceMessage(String text) {
        return MessageTranslator.replaceMessage(null, text);
    }

    public static String replaceMessage(Object targetObj, String text) {
        CommandSender sender = targetObj == null ? null : (targetObj instanceof CommandSender ? (CommandSender)targetObj : CommandSenderHandler.from(targetObj));
        String executorName = sender == null || sender.isConsole() ? "" : sender.getName();
        String token = Storage.ConfigSections.Settings.HANDLE_THROUGH_PROXY.ENABLED || Reflection.isProxyServer() ? Storage.TOKEN : "/";
        String serverName = Storage.SERVER_NAME == null ? "/" : Storage.SERVER_NAME;
        text = StringUtils.replace(text, "&", "\u00a7", "\\n", "\n", "%executor%", executorName, "%prefix%", Storage.ConfigSections.Messages.PREFIX.PREFIX, "%pat_general_prefix%", Storage.ConfigSections.Messages.PREFIX.PREFIX, "%token%", token, "%sync_server_name%", serverName, "%current_version%", Storage.CURRENT_VERSION, "%newest_version%", Storage.NEWER_VERSION);
        return PlaceholderReplacer.replace(targetObj, text);
    }

    public static String replaceMessageString(String rawText, String ... replacements) {
        return MessageTranslator.replaceMessage(StringUtils.replace(rawText, replacements));
    }

    public static String replaceMessageString(Object targetObj, String rawText, String ... replacements) {
        return MessageTranslator.replaceMessage(targetObj, StringUtils.replace(rawText, replacements));
    }

    public static List<String> replaceMessageList(MultipleMessagesHelper rawText, String ... replacements) {
        return MessageTranslator.replaceMessageList(rawText.getLines(), replacements);
    }

    public static List<String> replaceMessageList(List<String> rawText, String ... replacements) {
        HashMap<String, String> REPLACEMENTS = new HashMap<String, String>();
        ArrayList<String> result = new ArrayList<String>();
        if (replacements != null) {
            String firstReplacementInput = null;
            String secondReplacementInput = null;
            for (String replacement : replacements) {
                if (firstReplacementInput == null) {
                    firstReplacementInput = replacement;
                } else {
                    secondReplacementInput = replacement;
                }
                if (firstReplacementInput == null || secondReplacementInput == null) continue;
                REPLACEMENTS.put(firstReplacementInput, secondReplacementInput);
                firstReplacementInput = null;
                secondReplacementInput = null;
            }
        }
        rawText.forEach(text -> {
            if (replacements != null) {
                for (Map.Entry entry : REPLACEMENTS.entrySet()) {
                    text = text.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
            }
            String resultText = MessageTranslator.replaceMessage(text);
            result.add(resultText);
        });
        return result;
    }

    public static String translateIntoMiniMessage(String text) {
        return translator.translate(MessageTranslator.replaceMessage(text));
    }

    public static void closeAudiences() {
        if (translator == null) {
            return;
        }
        translator.close();
    }

    public static boolean isSupported() {
        return support;
    }

    static {
        translator = null;
    }
}

