/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.message.translators;

import de.rayzs.pat.plugin.BukkitLoader;
import de.rayzs.pat.utils.message.MessageTranslator;
import de.rayzs.pat.utils.message.Translator;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitMessageTranslator
implements Translator {
    private BukkitAudiences audiences;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public BukkitMessageTranslator() {
        this.audiences = BukkitAudiences.create(BukkitLoader.getPlugin());
    }

    @Override
    public String translate(String text) {
        return (String)this.miniMessage.serialize(this.miniMessage.deserialize(MessageTranslator.translateLegacy(text)));
    }

    @Override
    public void send(Object target, String text) {
        Audience audience = target instanceof Player ? this.audiences.player((Player)target) : this.audiences.sender((CommandSender)target);
        text = (String)this.miniMessage.serialize(LegacyComponentSerializer.legacyAmpersand().deserialize(text.replace("\u00a7", "&")));
        if (text.contains("\\")) {
            text = text.replace("\\", "");
        }
        audience.sendMessage((Component)this.miniMessage.deserialize(text));
    }

    @Override
    public void close() {
        this.audiences.close();
        this.audiences = null;
    }
}

