/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.node;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CommandNodeHelper<T> {
    private final RootCommandNode<T> rootNode;

    public CommandNodeHelper(RootCommandNode<T> rootNode) {
        this.rootNode = rootNode;
    }

    public List<String> getChildrenNames() {
        return this.rootNode.getChildren().stream().map(CommandNode::getName).collect(Collectors.toList());
    }

    public CommandNodeHelper<T> removeIf(CommandNode<T> node, Predicate<String> predicate) {
        if (node != null && node.getRedirect() != null) {
            node = node.getRedirect();
        }
        ArrayList<CommandNode> objs = new ArrayList<CommandNode>();
        for (CommandNode commandNode : node.getChildren()) {
            String name;
            if (commandNode == null || !predicate.test(name = commandNode.getName())) continue;
            objs.add(commandNode);
        }
        for (Object e : objs) {
            node.getChildren().remove(e);
        }
        return this;
    }

    public CommandNodeHelper<T> removeIf(String childName, Predicate<String> predicate) {
        CommandNode node = this.rootNode.getChild(childName);
        return this.removeIf(node, predicate);
    }

    public CommandNodeHelper<T> removeIf(Predicate<String> predicate) {
        return this.removeIf((CommandNode<T>)this.rootNode, predicate);
    }

    public CommandNodeHelper<T> clear() {
        this.rootNode.getChildren().clear();
        return this;
    }

    public CommandNodeHelper<T> clear(String childName) {
        CommandNode child = this.rootNode.getChild(childName);
        if (child != null) {
            child.getChildren().clear();
        }
        return this;
    }

    public CommandNodeHelper<T> remove(Object obj) {
        this.rootNode.getChildren().remove(obj);
        return this;
    }

    public CommandNodeHelper<T> remove(CommandNode node, Object obj) {
        node.getChildren().remove(obj);
        return this;
    }

    public CommandNodeHelper<T> add(String commandPath) {
        if (commandPath.endsWith("_-")) {
            commandPath = commandPath.substring(0, commandPath.length() - 3);
        }
        String[] args = commandPath.split(" ");
        this.add((CommandNode<T>)this.rootNode, args, 0);
        return this;
    }

    private void add(CommandNode<T> parent, String[] args, int index) {
        if (index >= args.length) {
            return;
        }
        String part = args[index];
        CommandNode childNode = parent.getChild(part);
        if (childNode == null) {
            LiteralCommandNode newNode = LiteralArgumentBuilder.literal((String)part).build();
            parent.addChild((CommandNode)newNode);
            childNode = newNode;
        }
        this.add(childNode, args, index + 1);
    }
}

