/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.sender;

import de.rayzs.pat.utils.ExpireCache;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.sender.CommandSender;
import de.rayzs.pat.utils.sender.CommandSenderAbstract;
import de.rayzs.pat.utils.sender.impl.BukkitSender;
import de.rayzs.pat.utils.sender.impl.BungeeSender;
import de.rayzs.pat.utils.sender.impl.VelocitySender;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.bukkit.entity.Player;

public class CommandSenderHandler {
    public static final UUID CONSOLE_UUID = UUID.randomUUID();
    private static final ExpireCache<UUID, CommandSender> CACHE = new ExpireCache(1L, TimeUnit.HOURS);

    public static CommandSender from(Object senderObj) {
        UUID uuid = CommandSenderHandler.extractUUID(senderObj);
        if (CACHE.contains(uuid)) {
            return CACHE.get(uuid);
        }
        CommandSenderAbstract sender = Reflection.isProxyServer() ? (Reflection.isVelocityServer() ? new VelocitySender(senderObj) : new BungeeSender(senderObj)) : new BukkitSender(senderObj);
        if (sender.getUniqueId() == null) {
            return null;
        }
        return CACHE.putAndGet(uuid, sender);
    }

    private static UUID extractUUID(Object targetObj) {
        if (Reflection.isProxyServer()) {
            if (Reflection.isVelocityServer()) {
                return targetObj instanceof com.velocitypowered.api.proxy.Player ? ((com.velocitypowered.api.proxy.Player)targetObj).getUniqueId() : CONSOLE_UUID;
            }
            return targetObj instanceof ProxiedPlayer ? ((ProxiedPlayer)targetObj).getUniqueId() : CONSOLE_UUID;
        }
        if (targetObj instanceof Player) {
            return ((Player)targetObj).getUniqueId();
        }
        return CONSOLE_UUID;
    }
}

