/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.brand.impl;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.scheduler.ScheduledTask;
import de.rayzs.pat.api.brand.ServerBrand;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.VelocityLoader;
import de.rayzs.pat.utils.PacketUtils;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.message.MessageTranslator;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class VelocityServerBrand
implements ServerBrand {
    private static final ProxyServer SERVER = VelocityLoader.getServer();
    private static Class<?> pluginMessagePacketClass;
    private static Class<?> minecraftConnectionClass;
    private static Class<?> connectedPlayerConnectionClass;
    private static Method connectionMethod;
    private static ScheduledTask TASK;
    private static String BRAND;

    @Override
    public void initializeTask() {
        if (TASK != null) {
            TASK.cancel();
        }
        if (!Storage.ConfigSections.Settings.CUSTOM_BRAND.ENABLED) {
            return;
        }
        if (pluginMessagePacketClass == null) {
            pluginMessagePacketClass = Reflection.getClass("com.velocitypowered.proxy.protocol.packet.PluginMessagePacket");
        }
        if (minecraftConnectionClass == null) {
            minecraftConnectionClass = Reflection.getClass("com.velocitypowered.proxy.connection.MinecraftConnection");
        }
        if (connectedPlayerConnectionClass == null) {
            connectedPlayerConnectionClass = Reflection.getClass("com.velocitypowered.proxy.connection.client.ConnectedPlayer");
        }
        if (connectionMethod == null) {
            connectionMethod = Reflection.getMethodByName(connectedPlayerConnectionClass, "getConnection");
        }
        if (Storage.ConfigSections.Settings.CUSTOM_BRAND.REPEAT_DELAY == -1) {
            BRAND = MessageTranslator.replaceMessage(Storage.ConfigSections.Settings.CUSTOM_BRAND.BRANDS.getLines().get(0)) + "\u00a7r";
            SERVER.getAllPlayers().forEach(this::send);
        } else {
            AtomicInteger animationState = new AtomicInteger(0);
            TASK = SERVER.getScheduler().buildTask((Object)VelocityLoader.getInstance(), () -> {
                if (animationState.getAndIncrement() >= Storage.ConfigSections.Settings.CUSTOM_BRAND.BRANDS.getLines().size() - 1) {
                    animationState.set(0);
                }
                BRAND = MessageTranslator.replaceMessage(Storage.ConfigSections.Settings.CUSTOM_BRAND.BRANDS.getLines().get(animationState.get())) + "\u00a7r";
                SERVER.getAllPlayers().forEach(this::send);
            }).repeat((long)Storage.ConfigSections.Settings.CUSTOM_BRAND.REPEAT_DELAY, TimeUnit.MILLISECONDS).schedule();
        }
    }

    @Override
    public void preparePlayer(Object playerObj) {
    }

    @Override
    public void send(Object playerObj) {
        if (!(playerObj instanceof Player) || !Storage.ConfigSections.Settings.CUSTOM_BRAND.ENABLED) {
            return;
        }
        try {
            Player player = (Player)playerObj;
            Object connectedPlayerObj = connectedPlayerConnectionClass.cast(player);
            Object minecraftConnectionObj = connectionMethod.invoke(connectedPlayerObj, new Object[0]);
            String serverName = "";
            String playerName = player.getUsername();
            Optional serverConnection = player.getCurrentServer();
            if (serverConnection.isPresent()) {
                serverName = ((ServerConnection)serverConnection.get()).getServerInfo().getName();
            }
            String customBrand = BRAND.replace("%player%", playerName).replace("%server%", serverName).replace("%ping%", String.valueOf(player.getPing()));
            PacketUtils.BrandManipulate serverBrand = new PacketUtils.BrandManipulate(customBrand, false);
            String brand = player.getProtocolVersion().getProtocol() >= 393 ? "minecraft:brand" : "MC|Brand";
            Object pluginMessagePacket = pluginMessagePacketClass.getConstructor(String.class, ByteBuf.class).newInstance(brand, serverBrand.getByteBuf());
            Reflection.getMethodsByParameterAndName(minecraftConnectionObj, "write", Object.class).get(0).invoke(minecraftConnectionObj, pluginMessagePacket);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public PacketUtils.BrandManipulate createPacket(Object playerObj) {
        if (!(playerObj instanceof Player) || !Storage.ConfigSections.Settings.CUSTOM_BRAND.ENABLED) {
            return null;
        }
        try {
            Player player = (Player)playerObj;
            String serverName = "";
            String playerName = player.getUsername();
            Optional serverConnection = player.getCurrentServer();
            if (serverConnection.isPresent()) {
                serverName = ((ServerConnection)serverConnection.get()).getServerInfo().getName();
            }
            String customBrand = BRAND.replace("%player%", playerName).replace("%server%", serverName).replace("%ping%", String.valueOf(player.getPing()));
            return new PacketUtils.BrandManipulate(customBrand, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static {
        BRAND = Storage.ConfigSections.Settings.CUSTOM_BRAND.BRANDS.getLines().get(0);
    }
}

