/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.netty.bukkit;

import de.rayzs.pat.api.netty.bukkit.BukkitPacketHandler;
import de.rayzs.pat.api.netty.bukkit.handlers.LegacyPacketHandler;
import de.rayzs.pat.api.netty.bukkit.handlers.ModernPacketHandler;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.ExpireCache;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.permission.PermissionUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class BukkitPacketAnalyzer {
    public static final ConcurrentHashMap<UUID, Channel> INJECTED_PLAYERS = new ConcurrentHashMap();
    private static final ExpireCache<UUID, Object> SENT_PACKET = new ExpireCache(2L, TimeUnit.SECONDS);
    private static final String HANDLER_NAME = "pat-bukkit-handler";
    private static final String PIPELINE_NAME = "packet_handler";
    private static final BukkitPacketHandler PACKET_HANDLER = Reflection.getMinor() >= 16 ? new ModernPacketHandler() : new LegacyPacketHandler();
    private static final HashMap<Player, String> PLAYER_INPUT_CACHE = new HashMap();

    public static void injectAll() {
        Bukkit.getOnlinePlayers().forEach(BukkitPacketAnalyzer::inject);
    }

    public static void uninjectAll() {
        ((ConcurrentHashMap.KeySetView)INJECTED_PLAYERS.keySet()).forEach(BukkitPacketAnalyzer::uninject);
        INJECTED_PLAYERS.clear();
    }

    public static void sendPacket(UUID uuid, Object object) {
        Channel channel = INJECTED_PLAYERS.get(uuid);
        if (channel == null) {
            return;
        }
        SENT_PACKET.put(uuid, object);
        channel.pipeline().writeAndFlush(object);
    }

    public static boolean inject(Player player) {
        if (Storage.USE_VELOCITY) {
            return true;
        }
        try {
            Channel channel = Reflection.getPlayerChannel(player);
            if (channel == null) {
                Logger.warning("Failed to inject " + player.getName() + "! Channel is null.");
                return false;
            }
            if (channel.pipeline().names().contains(HANDLER_NAME)) {
                BukkitPacketAnalyzer.uninject(channel);
            }
            channel.pipeline().addBefore(PIPELINE_NAME, HANDLER_NAME, (ChannelHandler)new PacketDecoder(player));
            INJECTED_PLAYERS.put(player.getUniqueId(), channel);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        return true;
    }

    public static void uninject(UUID uuid) {
        if (Storage.USE_VELOCITY) {
            return;
        }
        if (INJECTED_PLAYERS.containsKey(uuid)) {
            Channel channel = INJECTED_PLAYERS.get(uuid);
            BukkitPacketAnalyzer.uninject(channel);
        }
    }

    public static void uninject(Channel channel) {
        if (Storage.USE_VELOCITY) {
            return;
        }
        if (channel != null) {
            channel.eventLoop().submit(() -> {
                ChannelPipeline pipeline = channel.pipeline();
                if (pipeline.names().contains(HANDLER_NAME)) {
                    pipeline.remove(HANDLER_NAME);
                }
            });
        }
    }

    public static String getPlayerInput(Player player) {
        String input = PLAYER_INPUT_CACHE.get(player);
        PLAYER_INPUT_CACHE.remove(player);
        return input;
    }

    public static void insertPlayerInput(Player player, String text) {
        PLAYER_INPUT_CACHE.put(player, text);
    }

    private static class PacketDecoder
    extends ChannelDuplexHandler {
        private final Player player;

        private PacketDecoder(Player player) {
            this.player = player;
        }

        public void channelRead(ChannelHandlerContext channel, Object packetObj) {
            try {
                if (packetObj.getClass() != null) {
                    String packetName = packetObj.getClass().getSimpleName();
                    if (!packetName.equals("PacketPlayInTabComplete") && !packetName.equals("ServerboundCommandSuggestionPacket")) {
                        super.channelRead(channel, packetObj);
                        return;
                    }
                    if (!PermissionUtil.hasBypassPermission(this.player) && !PACKET_HANDLER.handleIncomingPacket(this.player, packetObj)) {
                        return;
                    }
                }
                super.channelRead(channel, packetObj);
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        }

        public void write(ChannelHandlerContext channel, Object packetObj, ChannelPromise promise) {
            try {
                if (packetObj.getClass() != null) {
                    String packetName = packetObj.getClass().getSimpleName();
                    if (!packetName.equals("PacketPlayOutTabComplete") && !packetName.equals("ClientboundCommandSuggestionsPacket")) {
                        super.write(channel, packetObj, promise);
                        return;
                    }
                    if (!PermissionUtil.hasBypassPermission(this.player)) {
                        UUID uuid = this.player.getUniqueId();
                        Object sentPacketObj = SENT_PACKET.get(uuid);
                        if (sentPacketObj != null && sentPacketObj == packetObj) {
                            SENT_PACKET.remove(uuid);
                            super.write(channel, sentPacketObj, promise);
                            return;
                        }
                        if (!PACKET_HANDLER.handleOutgoingPacket(this.player, packetObj)) {
                            return;
                        }
                    }
                }
                super.write(channel, packetObj, promise);
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        }
    }
}

