/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.storage.config.settings;

import de.rayzs.pat.api.storage.storages.ConfigStorage;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.configuration.helper.ConfigSectionHelper;
import de.rayzs.pat.utils.permission.PermissionUtil;

public class AutoLowercaseCommandsSection
extends ConfigStorage {
    public boolean ENABLED;

    public AutoLowercaseCommandsSection() {
        super("auto-lowercase-commands");
    }

    @Override
    public void load() {
        super.load();
        if (Reflection.isProxyServer()) {
            return;
        }
        this.ENABLED = (Boolean)new ConfigSectionHelper(this, "enabled", true).getOrSet();
    }

    public boolean isCommand(String command) {
        if (!this.ENABLED) {
            return false;
        }
        return !StringUtils.isLowercased(command);
    }

    public boolean doesBypass(Object targetObj) {
        return !this.ENABLED || PermissionUtil.hasPermission(targetObj, "auto-lowercase");
    }
}

