/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import de.rayzs.pat.api.brand.CustomServerBrand;
import de.rayzs.pat.api.communication.Communicator;
import de.rayzs.pat.api.event.PATEventHandler;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.PluginLoader;
import de.rayzs.pat.plugin.commands.VelocityCommand;
import de.rayzs.pat.plugin.listeners.velocity.VelocityAntiTabListener;
import de.rayzs.pat.plugin.listeners.velocity.VelocityConnectionListener;
import de.rayzs.pat.plugin.listeners.velocity.VelocityPingListener;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.plugin.metrics.impl.VelocityMetrics;
import de.rayzs.pat.plugin.modules.SubArgsModule;
import de.rayzs.pat.plugin.process.CommandProcess;
import de.rayzs.pat.utils.CommandsCache;
import de.rayzs.pat.utils.ConnectionBuilder;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.VersionComparer;
import de.rayzs.pat.utils.adapter.LuckPermsAdapter;
import de.rayzs.pat.utils.configuration.Configurator;
import de.rayzs.pat.utils.configuration.updater.ConfigUpdater;
import de.rayzs.pat.utils.group.GroupManager;
import de.rayzs.pat.utils.message.MessageTranslator;
import de.rayzs.pat.utils.permission.PermissionUtil;
import de.rayzs.pat.utils.response.action.ActionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

@Plugin(name="ProAntiTab", id="proantitab", version="2.0.3", authors={"Rayzs_YT"}, description="Hide more than just your plugins. Hide almost everything!", url="https://www.rayzs.de/products/proantitab/page", dependencies={@Dependency(id="luckperms", optional=true), @Dependency(id="papiproxybridge", optional=true)})
public class VelocityLoader
implements PluginLoader {
    private static VelocityLoader instance;
    private static ProxyServer server;
    private static org.slf4j.Logger logger;
    private final EventManager manager;
    private final VelocityMetrics.Factory metricsFactory;
    private ScheduledTask updaterTask;
    private static final HashMap<String, CommandsCache> commandsCacheMap;
    private static boolean checkUpdate;

    @Inject
    public VelocityLoader(ProxyServer server, org.slf4j.Logger logger, VelocityMetrics.Factory metricsFactory) {
        instance = this;
        VelocityLoader.server = server;
        VelocityLoader.logger = logger;
        this.manager = server.getEventManager();
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        PluginContainer pluginContainer = (PluginContainer)server.getPluginManager().getPlugin("proantitab").get();
        Configurator.createResourcedFile("files\\proxy-config.yml", "config.yml", false);
        Configurator.createResourcedFile("files\\proxy-storage.yml", "storage.yml", false);
        Configurator.createResourcedFile("files\\proxy-placeholders.yml", "placeholders.yml", false);
        Configurator.createResourcedFile("files\\proxy-custom-responses.yml", "custom-responses.yml", false);
        CommandProcess.initialize();
        Reflection.initialize(server);
        ConfigUpdater.initialize();
        Storage.USE_SIMPLECLOUD = Reflection.doesClassExist("eu.thesimplecloud.plugin.startup.CloudPlugin");
        Storage.initialize(this, (String)pluginContainer.getDescription().getVersion().get());
        VersionComparer.setCurrentVersion(Storage.CURRENT_VERSION);
        Storage.loadAll(true);
        MessageTranslator.initialize();
        CustomServerBrand.initialize();
        GroupManager.initialize();
        this.metricsFactory.make(this, 21638);
        server.getCommandManager().register("bpat", (Command)new VelocityCommand(), new String[]{"bungeeproantitab"});
        server.getEventManager().register((Object)this, (Object)new VelocityAntiTabListener(server));
        server.getEventManager().register((Object)this, (Object)new VelocityConnectionListener(server, this));
        server.getEventManager().register((Object)this, (Object)new VelocityPingListener(server));
        this.startUpdaterTask();
        if (!Storage.ConfigSections.Settings.DISABLE_SYNC.DISABLED) {
            server.getScheduler().buildTask((Object)this, Communicator::syncData).delay(5L, TimeUnit.SECONDS).schedule();
        }
        Storage.PLUGIN_OBJECT = this;
        if (server.getPluginManager().getPlugin("luckperms").isPresent()) {
            LuckPermsAdapter.initialize();
        }
        if (server.getPluginManager().getPlugin("papiproxybridge").isPresent()) {
            Storage.USE_PAPIPROXYBRIDGE = true;
            Logger.info("Successfully hooked into PAPIProxyBridge!");
        }
        if (Storage.USE_SIMPLECLOUD) {
            Logger.warning("Detected SimpleCloud and therefore MiniMessages by Kyori are disabled!");
        }
        ConfigUpdater.broadcastMissingParts();
        ActionHandler.initialize();
        SubArgsModule.initialize();
    }

    public static org.slf4j.Logger getPluginLogger() {
        return logger;
    }

    public static void delayedPermissionsReload() {
        server.getScheduler().buildTask((Object)instance, () -> {
            PermissionUtil.reloadPermissions();
            Storage.getLoader().updateCommandCache();
        }).delay(1L, TimeUnit.SECONDS).schedule();
    }

    public static void delayedPlayerReload(UUID uuid) {
        server.getScheduler().buildTask((Object)instance, () -> {
            String serverName = Storage.getLoader().getPlayerServerName(uuid);
            ArrayList<String> commands = new ArrayList<String>(SubArgsModule.getServerCommands(serverName));
            commands.addAll(SubArgsModule.getGroupCommands(uuid, serverName));
            PATEventHandler.callUpdatePlayerCommandsEvents(uuid, commands, true);
        }).delay(1L, TimeUnit.SECONDS).schedule();
    }

    @Override
    public Object getConsoleSender() {
        return server.getConsoleCommandSource();
    }

    @Override
    public Object getPlayerObjByName(String name) {
        return server.getPlayer(name).orElse(null);
    }

    @Override
    public Object getPlayerObjByUUID(UUID uuid) {
        return server.getPlayer(uuid).orElse(null);
    }

    @Override
    public void updateCommandCache() {
        new ArrayList<CommandsCache>(commandsCacheMap.values()).forEach(CommandsCache::reset);
    }

    @Override
    public HashMap<String, CommandsCache> getCommandsCacheMap() {
        return commandsCacheMap;
    }

    @Override
    public boolean isPlayerOnline(String playerName) {
        return server.getPlayer(playerName).isPresent();
    }

    @Override
    public boolean doesPlayerExist(String playerName) {
        return this.isPlayerOnline(playerName);
    }

    @Override
    public List<UUID> getPlayerIdsByServer(String serverName) {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        this.getServerNames().stream().filter(originServerName -> Storage.isServer(serverName, originServerName)).forEach(originServerName -> {
            Optional optionalRegServerInfo = server.getServer(serverName);
            if (optionalRegServerInfo.isEmpty()) {
                return;
            }
            RegisteredServer regServerInfo = (RegisteredServer)optionalRegServerInfo.get();
            uuids.addAll(regServerInfo.getPlayersConnected().stream().map(Player::getUniqueId).toList());
        });
        return uuids;
    }

    @Override
    public String getPlayerServerName(UUID uuid) {
        Optional optPlayer = server.getPlayer(uuid);
        if (optPlayer.isEmpty()) {
            return null;
        }
        Player player = (Player)optPlayer.get();
        Optional optConnection = player.getCurrentServer();
        if (optConnection.isEmpty()) {
            return null;
        }
        ServerConnection connection = (ServerConnection)optConnection.get();
        return connection.getServer().getServerInfo().getName();
    }

    @Override
    public List<UUID> getPlayerIds() {
        return server.getAllPlayers().stream().map(Player::getUniqueId).toList();
    }

    @Override
    public List<String> getOnlinePlayerNames(String serverName) {
        return server.getAllPlayers().stream().filter(player -> {
            Optional optConnection = player.getCurrentServer();
            if (optConnection.isEmpty()) {
                return false;
            }
            ServerConnection connection = (ServerConnection)optConnection.get();
            return connection.getServer().getServerInfo().getName().equalsIgnoreCase(serverName);
        }).map(Player::getUsername).toList();
    }

    @Override
    public List<String> getOnlinePlayerNames() {
        return server.getAllPlayers().stream().map(Player::getUsername).toList();
    }

    @Override
    public List<String> getOfflinePlayerNames() {
        return server.getAllPlayers().stream().map(Player::getUsername).toList();
    }

    @Override
    public List<String> getPlayerNames() {
        return server.getAllPlayers().stream().map(Player::getUsername).toList();
    }

    @Override
    public String getNameByUUID(UUID uuid) {
        Player player = server.getPlayer(uuid).orElse(null);
        return player != null ? player.getUsername() : "";
    }

    @Override
    public UUID getUUIDByName(String playerName) {
        Player player = server.getPlayer(playerName).orElse(null);
        return player != null ? player.getUniqueId() : null;
    }

    @Override
    public List<String> getServerNames() {
        return new ArrayList<String>(server.getAllServers().stream().map(registeredServer -> registeredServer.getServerInfo().getName()).toList());
    }

    public void startUpdaterTask() {
        if (!Storage.ConfigSections.Settings.UPDATE.ENABLED) {
            return;
        }
        this.updaterTask = server.getScheduler().buildTask((Object)this, () -> {
            String result = new ConnectionBuilder().setUrl("https://www.rayzs.de/proantitab/api/version.php").setProperties("ProAntiTab", "4654").connect().getResponse();
            if (result == null) {
                result = "/";
            }
            if (!result.equals("/")) {
                Storage.NEWER_VERSION = result;
                VersionComparer.setNewestVersion(Storage.NEWER_VERSION);
                if (VersionComparer.isDeveloperVersion()) {
                    this.updaterTask.cancel();
                    MessageTranslator.send((Object)server.getConsoleCommandSource(), "<dark_gray>[</dark_gray><white>PAT | Proxy</white><dark_gray>]</dark_gray> <gray>Please be aware that you are currently using a</gray> <aqua>developer</aqua> <gray>version of ProAntiTab. Bugs, errors and a lot of debug messages might be included.</gray>", new String[0]);
                } else if (!checkUpdate && (VersionComparer.isNewest() || VersionComparer.isUnreleased())) {
                    this.updaterTask.cancel();
                    checkUpdate = true;
                    if (VersionComparer.isUnreleased()) {
                        MessageTranslator.send((Object)server.getConsoleCommandSource(), "<dark_gray>[</dark_gray><white>PAT | Proxy</white><dark_gray>]</dark_gray> <gray>Please be aware that you are currently using an</gray> <yellow>unreleased</yellow> <gray>version of ProAntiTab.</gray>", new String[0]);
                        return;
                    }
                    checkUpdate = true;
                    MessageTranslator.send((Object)server.getConsoleCommandSource(), Storage.ConfigSections.Settings.UPDATE.UPDATED.getLines());
                } else if (VersionComparer.isOutdated()) {
                    Storage.OUTDATED = true;
                    MessageTranslator.send((Object)server.getConsoleCommandSource(), Storage.ConfigSections.Settings.UPDATE.OUTDATED.getLines());
                }
            } else {
                Logger.warning("Failed to connect to plugin page! Version comparison cannot be made. (No internet?)");
            }
        }).delay(1L, TimeUnit.SECONDS).repeat((long)Storage.ConfigSections.Settings.UPDATE.PERIOD, TimeUnit.SECONDS).schedule();
    }

    public static String getServerNameByPlayerUUID(UUID uuid) {
        Optional optPlayer = server.getPlayer(uuid);
        if (!optPlayer.isPresent()) {
            return null;
        }
        Player player = (Player)optPlayer.get();
        Optional optServer = player.getCurrentServer();
        if (!optServer.isPresent()) {
            return null;
        }
        ServerConnection server = (ServerConnection)optServer.get();
        if (server.getServerInfo() == null) {
            return null;
        }
        return server.getServerInfo().getName();
    }

    public static ProxyServer getServer() {
        return server;
    }

    public static VelocityLoader getInstance() {
        return instance;
    }

    static {
        commandsCacheMap = new HashMap();
        checkUpdate = false;
    }
}

