/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin.listeners.bukkit;

import de.rayzs.pat.api.event.PATEventHandler;
import de.rayzs.pat.api.event.events.FilteredSuggestionEvent;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.BukkitLoader;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.CommandsCache;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.adapter.ViaVersionAdapter;
import de.rayzs.pat.utils.permission.PermissionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandSendEvent;

public class BukkitAntiTabListener
implements Listener {
    private static final CommandsCache COMMANDS_CACHE = new CommandsCache();

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandSend(PlayerCommandSendEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        String uuidSubstring = uuid.toString().substring(uuid.toString().length() - 5);
        if (Storage.USE_VELOCITY || player.isOp()) {
            Logger.debug("Doesn't even tried to create the commands list for player with uuid " + uuidSubstring + ". (Veloctiy? " + Storage.USE_VELOCITY + ". OP? " + player.isOp() + ")");
            return;
        }
        if (!BukkitLoader.isLoaded()) {
            event.getCommands().clear();
            Logger.debug("Doesn't even tried to create the commands list for player with uuid " + uuidSubstring + ". (not loaded)");
            return;
        }
        if (Storage.ConfigSections.Settings.HANDLE_THROUGH_PROXY.ENABLED) {
            return;
        }
        if (event.getCommands().isEmpty()) {
            Logger.debug("No available commands to filter! Ignoring rest of the code until at least one command is listed in there.");
            return;
        }
        List<String> allCommands = BukkitAntiTabListener.getCommands();
        COMMANDS_CACHE.handleCommands(allCommands);
        if (PermissionUtil.hasBypassPermission(player)) {
            Logger.debug("Player with uuid " + uuidSubstring + " skipped the commands-list creation due to its permissions.");
            return;
        }
        List<String> playerCommands = COMMANDS_CACHE.getPlayerCommands(new ArrayList<String>(event.getCommands()), player, player.getUniqueId());
        FilteredSuggestionEvent filteredSuggestionEvent = PATEventHandler.callFilteredSuggestionEvents(player, playerCommands);
        event.getCommands().clear();
        if (filteredSuggestionEvent.isCancelled()) {
            return;
        }
        event.getCommands().addAll(filteredSuggestionEvent.getSuggestions());
        Logger.debug("Player with uuid " + uuidSubstring + " has a total of " + playerCommands.size() + " commands.");
    }

    public static List<String> getCommands() {
        return Storage.ConfigSections.Settings.TURN_BLACKLIST_TO_WHITELIST.ENABLED ? Storage.Blacklist.getBlacklist().getCommands() : BukkitLoader.getAllCommands();
    }

    private static boolean notUpdatablePlayer(UUID uuid) {
        return Storage.USE_VIAVERSION && Reflection.getMinor() >= 16 && ViaVersionAdapter.getPlayerProtocol(uuid) < 754;
    }

    public static void luckpermsNetworkSync() {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(BukkitLoader.getPlugin(), PermissionUtil::reloadPermissions, 40L);
    }

    public static void luckpermsNetworkUserSync(UUID uuid) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(BukkitLoader.getPlugin(), () -> PermissionUtil.reloadPermissions(uuid));
    }

    public static void updateCommands() {
        Bukkit.getOnlinePlayers().forEach(BukkitAntiTabListener::updateCommands);
    }

    public static void updateCommands(Player player) {
        if (Reflection.getMinor() >= 13 && !BukkitAntiTabListener.notUpdatablePlayer(player.getUniqueId())) {
            player.updateCommands();
        }
    }

    public static void handleTabCompletion() {
        COMMANDS_CACHE.reset();
        Bukkit.getOnlinePlayers().forEach(BukkitAntiTabListener::handleTabCompletion);
    }

    public static void handleTabCompletion(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        BukkitAntiTabListener.handleTabCompletion(player);
    }

    public static void handleTabCompletion(Player player) {
        BukkitAntiTabListener.handleTabCompletion(player, BukkitAntiTabListener.getCommands());
    }

    public static void handleTabCompletion(Player player, List<String> commands) {
        if (BukkitAntiTabListener.notUpdatablePlayer(player.getUniqueId())) {
            return;
        }
        ArrayList<String> dummy = new ArrayList<String>(commands);
        PlayerCommandSendEvent event = new PlayerCommandSendEvent(player, dummy);
        Bukkit.getPluginManager().callEvent((Event)event);
        BukkitAntiTabListener.updateCommands(player);
    }
}

