/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin.logger.impl;

import de.rayzs.pat.plugin.BungeeLoader;
import de.rayzs.pat.plugin.logger.LoggerPriority;
import de.rayzs.pat.plugin.logger.LoggerTemplate;
import de.rayzs.pat.utils.message.MessageTranslator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import net.md_5.bungee.api.ProxyServer;

public class BungeeLogger
implements LoggerTemplate {
    private final List<String> LOGS = new ArrayList<String>();
    private final Logger logger = BungeeLoader.getPluginLogger();

    @Override
    public List<String> getLogs() {
        return this.LOGS;
    }

    @Override
    public void info(List<String> messages) {
        messages.forEach(this::info);
    }

    @Override
    public void warn(List<String> messages) {
        messages.forEach(this::warn);
    }

    @Override
    public void debug(List<String> messages) {
        messages.forEach(this::debug);
    }

    @Override
    public void send(LoggerPriority priority, List<String> messages) {
        messages.forEach(message -> this.send(priority, (String)message));
    }

    @Override
    public void info(String message) {
        this.send(LoggerPriority.INFO, message);
    }

    @Override
    public void warn(String message) {
        this.send(LoggerPriority.WARNING, message);
    }

    @Override
    public void debug(String message) {
        this.send(LoggerPriority.DEBUG, message);
    }

    @Override
    public void send(LoggerPriority priority, String message) {
        message = MessageTranslator.replaceMessage(message);
        Object time = TIME_FORMAT.format(new Date(System.currentTimeMillis()));
        if (((String)time).length() != 12) {
            time = ((String)time).substring(0, 9) + "0" + ((String)time).split(":")[3];
        }
        this.LOGS.add("[" + priority.name() + " | " + (String)time + "] " + MessageTranslator.colorless(message));
        if (priority == LoggerPriority.DEBUG) {
            return;
        }
        if (message.contains("\u00a7")) {
            MessageTranslator.send((Object)ProxyServer.getInstance().getConsole(), message, new String[0]);
            return;
        }
        switch (priority) {
            case INFO: {
                this.logger.info(message);
                break;
            }
            case WARNING: {
                this.logger.warning(message);
            }
        }
    }
}

