/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;

public class ExpireCache<T, K> {
    private final Cache<Object, Object> cache;

    public ExpireCache(long expireTime, TimeUnit timeUnit) {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(2).expireAfterWrite(expireTime, timeUnit).build();
    }

    public ExpireCache(ExpireCache<T, K> expireList) {
        this.cache = expireList.getCache();
    }

    public boolean put(T t, K k) {
        if (this.contains(t)) {
            return false;
        }
        this.cache.put(t, k);
        return true;
    }

    public boolean remove(T t) {
        if (!this.contains(t)) {
            return false;
        }
        this.cache.invalidate(t);
        return true;
    }

    public K putAndGet(T t, K k) {
        this.put(t, k);
        return k;
    }

    public void clear() {
        this.cache.cleanUp();
    }

    public void putIgnoreIfContains(T t, K k) {
        this.cache.put(t, k);
    }

    public K get(T t) {
        Object result = this.cache.getIfPresent(t);
        return (K)(result == null ? null : result);
    }

    public K getOrDefault(T t, K k) {
        Object result = this.cache.getIfPresent(t);
        return (K)(result == null ? k : result);
    }

    public int getSize() {
        this.cache.cleanUp();
        return (int)this.cache.size();
    }

    public Cache<Object, Object> getCache() {
        return this.cache;
    }

    public boolean contains(T t) {
        return this.cache.getIfPresent(t) != null;
    }

    public boolean containsValue(K k) {
        return this.cache.asMap().containsValue(k);
    }
}

