/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.permission;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class PermissionMap {
    private final UUID uuid;
    private final HashMap<String, Boolean> permissionMap = new HashMap();

    public PermissionMap(UUID uuid) {
        this.uuid = uuid;
    }

    public void remove(String permission) {
        this.permissionMap.remove(permission);
    }

    public Map<String, Boolean> getPermissionMap() {
        return this.permissionMap;
    }

    public Set<String> getHashedPermissions() {
        return this.permissionMap.keySet().stream().filter(this.permissionMap::get).collect(Collectors.toSet());
    }

    public void clear() {
        this.permissionMap.clear();
    }

    public void setState(String permission, boolean permitted) {
        this.permissionMap.put(permission, permitted);
    }

    public void setStateIfEmpty(String permission, boolean permitted) {
        this.permissionMap.putIfAbsent(permission, permitted);
    }

    public boolean isPermitted(String permission) {
        return this.getPermissionState(permission) == PermissionState.PERMITTED;
    }

    public PermissionState getPermissionState(String permission) {
        if (!this.hasPermissionState(permission)) {
            return PermissionState.EMPTY;
        }
        return this.permissionMap.get(permission) != false ? PermissionState.PERMITTED : PermissionState.DENIED;
    }

    public boolean hasPermissionState(String permission) {
        return this.permissionMap.containsKey(permission);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    static enum PermissionState {
        PERMITTED,
        DENIED,
        EMPTY;

    }
}

