/*
 * Decompiled with CFR 0.152.
 */
package com.magafin.abundant_delight.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.sheddmer.abundant_atmosphere.common.init.AAParticleTypes;
import net.sheddmer.abundant_atmosphere.common.init.AASounds;
import vectorwing.farmersdelight.common.block.PieBlock;

public class WispCheesecakeBlock
extends PieBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public WispCheesecakeBlock(BlockBehaviour.Properties properties, Supplier<Item> pieSlice) {
        super(properties, pieSlice);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (heldStack.is(Items.FLINT_AND_STEEL)) {
                if (!player.isCreative()) {
                    heldStack.setDamageValue(heldStack.getDamageValue() - 1);
                }
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, (level.random.nextFloat() - level.random.nextFloat()) * 0.8f + 1.8f);
                level.playLocalSound(pos, (SoundEvent)AASounds.WISP_CANDLE_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                if (!level.isClientSide && !player.isCreative()) {
                    heldStack.hurtAndBreak(1, (LivingEntity)player, heldStack.getEquipmentSlot());
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (heldStack.is(Items.FIRE_CHARGE)) {
                if (!player.isCreative()) {
                    heldStack.setDamageValue(heldStack.getDamageValue() - 1);
                }
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, (level.random.nextFloat() - level.random.nextFloat()) * 0.8f + 1.8f);
                level.playLocalSound(pos, (SoundEvent)AASounds.WISP_CANDLE_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                if (!level.isClientSide && !player.isCreative()) {
                    heldStack.hurtAndBreak(1, (LivingEntity)player, heldStack.getEquipmentSlot());
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(heldStack, state, level, pos, player, hand, hit);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        return InteractionResult.FAIL;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && (Integer)state.getValue((Property)BITES) == 0) {
            Vec3 position = new Vec3(0.5, 0.5, 0.5);
            WispCheesecakeBlock.addParticlesAndSound(level, position.add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), random);
        }
    }

    private static void addParticlesAndSound(Level level, Vec3 offset, RandomSource source) {
        float f = source.nextFloat();
        if (f < 0.3f) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                level.playLocalSound(offset.x + 0.5, offset.y + 0.5, offset.z + 0.5, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + source.nextFloat(), source.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        if (f < 0.5f) {
            level.addParticle((ParticleOptions)AAParticleTypes.WISP_FLAME.get(), offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BITES, LIT});
    }
}

