/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.sculk_radio;

import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import nl.gjorgdy.sculk_radio.interfaces.INodeContainer;
import nl.gjorgdy.sculk_radio.interfaces.ISculkRadioApi;
import nl.gjorgdy.sculk_radio.objects.Node;
import nl.gjorgdy.sculk_radio.objects.SourceNode;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SculkRadio {
    public static Logger LOGGER = LoggerFactory.getLogger((String)"Sculk Radio");
    private static API apiInstance = null;

    public static void RunIfServerActive(Runnable runnable) {
        ServerLifecycleEvents.SERVER_STARTED.register(s -> runnable.run());
    }

    public static ISculkRadioApi api() {
        if (apiInstance == null) {
            apiInstance = new API();
        }
        return apiInstance;
    }

    private static class API
    implements ISculkRadioApi {
        private API() {
        }

        @Override
        public boolean isRadio(class_3218 world, class_2338 pos) {
            return this.getNode(world, pos) != null;
        }

        @Override
        public boolean connect(class_3218 world, class_2338 pos, Consumer<Node> connectCallback, Consumer<Node> disconnectCallback, Consumer<Node> tickCallback) {
            Node node = this.getNode(world, pos);
            if (node instanceof SourceNode) {
                SourceNode sn = (SourceNode)node;
                sn.initialize(connectCallback, disconnectCallback, tickCallback);
                return true;
            }
            return false;
        }

        @Override
        public boolean disconnect(class_3218 world, class_2338 pos) {
            Node node = this.getNode(world, pos);
            if (node != null) {
                node.disconnect();
                return true;
            }
            return false;
        }

        @Override
        public boolean tick(class_3218 world, class_2338 pos) {
            Node node = this.getNode(world, pos);
            if (node != null) {
                node.tick();
                return true;
            }
            return false;
        }

        @Nullable
        private Node getNode(class_3218 world, class_2338 pos) {
            class_2586 blockEntity = world.method_8321(pos.method_10084());
            if (blockEntity instanceof INodeContainer) {
                INodeContainer nc = (INodeContainer)blockEntity;
                return nc.sculkRadio$getNode();
            }
            return null;
        }
    }
}

