/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.sculk_radio.objects;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public abstract class Node {
    private final class_2338 pos;
    private final class_3218 world;
    protected final Set<Node> receivers = new ObjectArraySet(8);
    protected Node transmitter = null;
    private Consumer<Node> disconnectCallback;
    private Consumer<Node> tickCallback;

    public Node(class_3218 world, class_2338 pos) {
        this.world = world;
        this.pos = pos;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_3218 getWorld() {
        return this.world;
    }

    protected void internalInitialize(Consumer<Node> connectCallback, Consumer<Node> disconnectCallback, Consumer<Node> tickCallback) {
        this.disconnectCallback = disconnectCallback;
        this.tickCallback = tickCallback;
        connectCallback.accept(this);
    }

    public boolean connect(Node toNode) {
        toNode.transmitter = this;
        return true;
    }

    public boolean isConnected() {
        return this.transmitter != null;
    }

    public abstract boolean isActive();

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.transmitter = null;
        if (this.disconnectCallback != null) {
            this.disconnectCallback.accept(this);
        }
    }

    public final void tick() {
        if (this.isConnected()) {
            if (this.tickCallback != null) {
                this.tickCallback.accept(this);
            }
            this.internalTick();
        }
    }

    protected abstract void internalTick();
}

