/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.sculk_radio;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import nl.gjorgdy.sculk_radio.objects.CalibratedReceiverNode;
import nl.gjorgdy.sculk_radio.objects.Node;
import nl.gjorgdy.sculk_radio.objects.ReceiverNode;
import nl.gjorgdy.sculk_radio.objects.RepeaterNode;
import nl.gjorgdy.sculk_radio.objects.SourceNode;
import org.jetbrains.annotations.Nullable;

public class NodeRegistry {
    public static NodeRegistry INSTANCE = new NodeRegistry();
    private final List<SourceNode> sourceNodes = new ArrayList<SourceNode>();
    private final List<RepeaterNode> repeaterNodes = new ArrayList<RepeaterNode>();
    private final List<ReceiverNode> receiverNodes = new ArrayList<ReceiverNode>();
    private final List<CalibratedReceiverNode> calibratedReceiverNodes = new ArrayList<CalibratedReceiverNode>();

    private NodeRegistry() {
    }

    public SourceNode registerSourceNode(class_3218 world, class_2338 pos) {
        SourceNode node = new SourceNode(world, pos);
        this.sourceNodes.add(node);
        return node;
    }

    public ReceiverNode registerReceiverNode(class_3218 world, class_2338 pos) {
        ReceiverNode node = new ReceiverNode(world, pos);
        this.receiverNodes.add(node);
        return node;
    }

    public CalibratedReceiverNode registerCalibratedReceiverNode(class_3218 world, class_2338 pos) {
        CalibratedReceiverNode node = new CalibratedReceiverNode(world, pos);
        this.calibratedReceiverNodes.add(node);
        return node;
    }

    public RepeaterNode registerRepeaterNode(class_3218 world, class_2338 pos) {
        RepeaterNode node = new RepeaterNode(world, pos);
        this.repeaterNodes.add(node);
        return node;
    }

    public void removeNode(Node node) {
        System.out.println("removed node at " + String.valueOf(node.getPos()));
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SourceNode.class, RepeaterNode.class, CalibratedReceiverNode.class, ReceiverNode.class}, (Object)node3, n)) {
            case 0: {
                SourceNode sourceNode = (SourceNode)node3;
                this.sourceNodes.remove(sourceNode);
                break;
            }
            case 1: {
                RepeaterNode repeaterNode = (RepeaterNode)node3;
                this.repeaterNodes.remove(repeaterNode);
                break;
            }
            case 2: {
                CalibratedReceiverNode calibratedReceiverNode = (CalibratedReceiverNode)node3;
                this.calibratedReceiverNodes.remove(calibratedReceiverNode);
                break;
            }
            case 3: {
                ReceiverNode receiverNode = (ReceiverNode)node3;
                this.receiverNodes.remove(receiverNode);
                break;
            }
        }
        node.disconnect();
    }

    public void connectNodes(SourceNode sn) {
        this.internalConnectNodes(sn, 0);
    }

    private void internalConnectNodes(Node node, int depth) {
        boolean connected;
        RepeaterNode rn;
        if (depth >= 8 || node == null) {
            return;
        }
        for (ReceiverNode rn2 : this.getClosestNodes(node, this.receiverNodes, 8)) {
            boolean connected2 = node.connect(rn2);
            if (!connected2) continue;
            rn2.connect(node);
        }
        while ((rn = this.getClosestNode(node, this.repeaterNodes)) != null && (connected = node.connect(rn))) {
            this.internalConnectNodes(rn, depth + 1);
        }
    }

    public <T extends Node> Collection<T> getClosestNodes(Node node, Collection<T> nodes, int count) {
        return nodes.stream().filter(n -> !n.isConnected() && n.getPos().method_65076((class_2382)node.getPos()) < 16 && n != node).sorted(Comparator.comparingInt(a -> a.getPos().method_19455((class_2382)node.getPos()))).limit(count).collect(Collectors.toSet());
    }

    @Nullable
    public <T extends Node> T getClosestNode(Node node, Collection<T> nodes) {
        return (T)((Node)nodes.stream().filter(n -> !n.isConnected() && n.getPos().method_65076((class_2382)node.getPos()) < 16 && n != node).min(Comparator.comparingInt(a -> a.getPos().method_19455((class_2382)node.getPos()))).orElse(null));
    }
}

