/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.sculk_radio.compat.audio_player;

import de.maxhenkel.audioplayer.voicechat.VoicechatAudioPlayerPlugin;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class MultiLocationalAudioChannel
implements LocationalAudioChannel {
    private final UUID id;
    private Position sourcePosition;
    private float distance;
    private Predicate<ServerPlayer> filter;
    private String category;
    private final Map<Position, LocationalAudioChannel> audioChannels = new HashMap<Position, LocationalAudioChannel>();

    public MultiLocationalAudioChannel(UUID id, Position sourcePosition) {
        this.id = id;
        this.sourcePosition = sourcePosition;
    }

    public void updateLocation(Position position) {
        this.sourcePosition = position;
    }

    public void addChannel(class_3218 level, class_243 pos) {
        VoicechatServerApi api = VoicechatAudioPlayerPlugin.voicechatServerApi;
        if (api == null) {
            return;
        }
        Position position = api.createPosition(pos.field_1352, pos.field_1351, pos.field_1350);
        LocationalAudioChannel channel = api.createLocationalAudioChannel(UUID.randomUUID(), api.fromServerLevel((Object)level), position);
        if (channel == null) {
            return;
        }
        channel.setDistance(this.distance);
        channel.setFilter(this.filter);
        channel.setCategory(this.category);
        this.audioChannels.put(position, channel);
    }

    public void removeChannel(class_243 pos) {
        VoicechatServerApi api = VoicechatAudioPlayerPlugin.voicechatServerApi;
        if (api == null) {
            return;
        }
        Position position = api.createPosition(pos.field_1352, pos.field_1351, pos.field_1350);
        LocationalAudioChannel channel = this.audioChannels.remove(position);
        channel.flush();
    }

    public Position getLocation() {
        return this.sourcePosition;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setDistance(float distance) {
        this.distance = distance;
        this.audioChannels.values().forEach(channel -> channel.setDistance(distance));
    }

    public void send(byte[] opusData) {
        this.audioChannels.values().forEach(channel -> channel.send(opusData));
    }

    public void send(MicrophonePacket packet) {
        this.audioChannels.values().forEach(channel -> channel.send(packet));
    }

    public void setFilter(Predicate<ServerPlayer> filter) {
        this.filter = filter;
        this.audioChannels.values().forEach(channel -> channel.setFilter(filter));
    }

    public void flush() {
        this.audioChannels.values().forEach(AudioChannel::flush);
    }

    public boolean isClosed() {
        return this.audioChannels.values().stream().allMatch(AudioChannel::isClosed);
    }

    public UUID getId() {
        return this.id;
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    public void setCategory(@Nullable String category) {
        this.category = category;
        this.audioChannels.values().forEach(channel -> channel.setCategory(category));
    }
}

