/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.sculk_radio.objects;

import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import nl.gjorgdy.sculk_radio.objects.Node;
import nl.gjorgdy.sculk_radio.utils.ParticleUtils;

public abstract class TransmittingNode
extends Node {
    public TransmittingNode(class_3218 world, class_2338 pos) {
        super(world, pos);
    }

    @Override
    public void internalTick() {
        this.receivers.removeIf(n -> {
            if (!n.isActive()) {
                n.disconnect();
                return true;
            }
            return false;
        });
        this.receivers.forEach(n -> {
            ParticleUtils.spawnVibrationParticles(this, n);
            n.tick();
        });
    }

    @Override
    protected void internalInitialize(Consumer<Node> connectCallback, Consumer<Node> disconnectCallback, Consumer<Node> tickCallback) {
        this.receivers.forEach(node -> node.internalInitialize(connectCallback, disconnectCallback, tickCallback));
    }

    @Override
    public void disconnect() {
        this.receivers.forEach(Node::disconnect);
        this.receivers.clear();
        super.disconnect();
    }

    @Override
    public boolean connect(Node toNode) {
        if (toNode.isConnected() || toNode == this) {
            return false;
        }
        if (this.receivers.size() < 8) {
            boolean connected = this.receivers.add(toNode);
            if (connected) {
                toNode.transmitter = this;
            }
            return connected;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return !this.receivers.isEmpty() && super.isConnected();
    }

    @Override
    public boolean isActive() {
        return !this.receivers.isEmpty() && this.receivers.stream().anyMatch(Node::isActive);
    }
}

