/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.command;

import com.google.common.base.Strings;
import java.util.List;
import me.chancesd.pvpmanager.PvPManager;
import me.chancesd.pvpmanager.player.CombatPlayer;
import me.chancesd.pvpmanager.player.world.CombatWorld;
import me.chancesd.pvpmanager.sdutils.command.ArgumentType;
import me.chancesd.pvpmanager.sdutils.command.BaseCommand;
import me.chancesd.pvpmanager.sdutils.command.CommandArgument;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.setting.Lang;
import me.chancesd.pvpmanager.setting.Permissions;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Worlds
extends BaseCommand {
    private final PvPManager plugin;

    public Worlds(PvPManager plugin) {
        this.plugin = plugin;
        this.description("Control panel to manage world PvP").usage("/pmr worlds [list|set] [world] [option] [value]").permission(Permissions.ADMIN.getPermission());
        this.subCommand("list", new WorldsListCommand());
        this.subCommand("set", new WorldsSetCommand());
    }

    @Override
    public void execute(CommandSender sender, String label, List<CommandArgument> args) {
        if (args.isEmpty()) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.createWorldMenu(player);
            } else {
                sender.sendMessage("\u00a7cConsole must use '/pmr worlds list' to see world information.");
            }
        }
    }

    public void createWorldMenu(Player player) {
        TextComponent menuHeader = new TextComponent(String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "World Combat Manager\n");
        player.spigot().sendMessage((BaseComponent)menuHeader);
        for (CombatWorld combatWorld : this.plugin.getWorldManager().getWorlds()) {
            TextComponent worldItem = new TextComponent(String.valueOf(ChatColor.DARK_AQUA) + String.valueOf(ChatColor.BOLD) + "World: " + String.valueOf(ChatColor.GOLD) + combatWorld.getName() + String.valueOf(ChatColor.AQUA) + " \n  ");
            World world = Bukkit.getWorld((String)combatWorld.getName());
            if (world == null) {
                Log.warning("Null world in world list!");
                continue;
            }
            List<CombatPlayer> pvPlayerList = world.getPlayers().stream().map(p -> this.plugin.getPlayerManager().get((Player)p)).toList();
            worldItem.addExtra((BaseComponent)this.createInfoText("Players", pvPlayerList.size()));
            worldItem.addExtra((BaseComponent)this.createSeparator());
            worldItem.addExtra((BaseComponent)this.createInfoText("In Combat", pvPlayerList.stream().filter(CombatPlayer::isInCombat).count()));
            worldItem.addExtra((BaseComponent)this.createSeparator());
            worldItem.addExtra((BaseComponent)this.createInfoText("PvP On", pvPlayerList.stream().filter(CombatPlayer::hasPvPEnabled).count()));
            worldItem.addExtra((BaseComponent)this.createSeparator());
            worldItem.addExtra((BaseComponent)this.createInfoText("PvP Off", pvPlayerList.stream().filter(pvPlayer -> !pvPlayer.hasPvPEnabled()).count()));
            player.spigot().sendMessage((BaseComponent)worldItem);
            player.sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "  Options");
            String pvpHoverText = String.valueOf(ChatColor.BLUE) + String.valueOf(ChatColor.BOLD) + "Enables or disables PvP in " + String.valueOf(ChatColor.YELLOW) + combatWorld.getName() + "\n\n" + String.valueOf(ChatColor.GREEN) + "On - Enables PvP\n" + String.valueOf(ChatColor.RED) + "Off - Disables PvP";
            BaseComponent[] pvpEnabled = this.createFeature(String.format("/pmr worlds set %s PvP", combatWorld.getName()), pvpHoverText, "PvP", CombatWorld.WorldOptionState.fromBoolean(combatWorld.isCombatAllowed()), false);
            String forcepvpHoverText = String.valueOf(ChatColor.BLUE) + String.valueOf(ChatColor.BOLD) + "Forces a PvP state in " + String.valueOf(ChatColor.YELLOW) + combatWorld.getName() + "\n\n" + String.valueOf(ChatColor.GREEN) + "On - Forces PvP to enabled and blocks players from turning it off\n" + String.valueOf(ChatColor.RED) + "Off - Forces PvP to disabled and blocks players from turning it on\n" + String.valueOf(ChatColor.DARK_PURPLE) + "Neutral - Does nothing, just leaves the player with the PvP state they already had";
            BaseComponent[] forcePvP = this.createFeature(String.format("/pmr worlds set %s ForcePvP", combatWorld.getName()), forcepvpHoverText, "Force PvP", combatWorld.isPvPForced(), true);
            player.spigot().sendMessage(pvpEnabled);
            player.spigot().sendMessage(forcePvP);
        }
    }

    private BaseComponent[] createFeature(String command, String hoverText, String displayName, CombatWorld.WorldOptionState state, boolean thirdState) {
        ComponentBuilder builder = new ComponentBuilder();
        builder.append(String.valueOf(ChatColor.DARK_AQUA) + "    - " + String.valueOf(ChatColor.GRAY) + displayName).color(ChatColor.GRAY);
        builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hoverText)}));
        builder.append(String.valueOf(ChatColor.DARK_GRAY) + Strings.repeat((String)".", (int)((int)(75.0 - (double)displayName.length() * 2.86))) + " ");
        BaseComponent[] onButton = this.createToggleButton(command, "On", ChatColor.GREEN, state, CombatWorld.WorldOptionState.ON);
        BaseComponent[] offButton = this.createToggleButton(command, "Off", ChatColor.RED, state, CombatWorld.WorldOptionState.OFF);
        builder.append(onButton);
        builder.append(" ", ComponentBuilder.FormatRetention.NONE);
        builder.append(offButton);
        if (thirdState) {
            BaseComponent[] neutralButton = this.createToggleButton(command, "Neutral", ChatColor.DARK_PURPLE, state, CombatWorld.WorldOptionState.NONE);
            builder.append(" ", ComponentBuilder.FormatRetention.NONE);
            builder.append(neutralButton);
        }
        return builder.create();
    }

    private BaseComponent[] createToggleButton(String command, String text, ChatColor color, CombatWorld.WorldOptionState state, CombatWorld.WorldOptionState selectedState) {
        BaseComponent[] stateComp;
        Object hoverText = "";
        Object finalCommand = "";
        if (state == selectedState) {
            stateComp = new ComponentBuilder(text).color(color).create();
            hoverText = String.valueOf(ChatColor.DARK_RED) + "Click to unselect this option";
            finalCommand = command + " " + String.valueOf((Object)CombatWorld.WorldOptionState.getOpposite(selectedState)) + " --menu";
        } else {
            stateComp = new ComponentBuilder(text).color(ChatColor.DARK_GRAY).create();
            hoverText = String.valueOf(ChatColor.DARK_GREEN) + "Click to select this option";
            finalCommand = command + " " + String.valueOf((Object)selectedState) + " --menu";
        }
        ComponentBuilder builder = new ComponentBuilder();
        builder.event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, (String)finalCommand));
        builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text((String)hoverText)}));
        builder.append("[").color(ChatColor.DARK_GRAY).append(stateComp).append("]").color(ChatColor.DARK_GRAY);
        return builder.create();
    }

    private TextComponent createInfoText(String text, long value) {
        return new TextComponent(String.valueOf(ChatColor.DARK_AQUA) + text + ": " + String.valueOf(ChatColor.YELLOW) + value);
    }

    private TextComponent createSeparator() {
        return new TextComponent(String.valueOf(ChatColor.DARK_GRAY) + " | ");
    }

    private class WorldsListCommand
    extends BaseCommand {
        public WorldsListCommand() {
            this.description("List all worlds and their PvP settings").usage("/pmr worlds list").permission(Permissions.ADMIN.getPermission());
        }

        @Override
        public void execute(CommandSender sender, String label, List<CommandArgument> args) {
            sender.sendMessage("\u00a76\u00a7l--- World PvP Settings ---");
            for (CombatWorld combatWorld : Worlds.this.plugin.getWorldManager().getWorlds()) {
                String pvpStatus = combatWorld.isCombatAllowed() ? "\u00a7a\u2713 Enabled" : "\u00a7c\u2717 Disabled";
                String forceStatus = switch (combatWorld.isPvPForced()) {
                    default -> throw new IncompatibleClassChangeError();
                    case CombatWorld.WorldOptionState.ON -> "\u00a7a[Force ON]";
                    case CombatWorld.WorldOptionState.OFF -> "\u00a7c[Force OFF]";
                    case CombatWorld.WorldOptionState.NONE -> "\u00a77[Normal]";
                };
                sender.sendMessage(String.format("\u00a7e%s: \u00a7fPvP %s %s", combatWorld.getName(), pvpStatus, forceStatus));
            }
        }
    }

    private class WorldsSetCommand
    extends BaseCommand {
        public WorldsSetCommand() {
            this.description("Set world PvP options").usage("/pmr worlds set <world> <option> <value> [--menu]").permission(Permissions.ADMIN.getPermission()).argument("world", ArgumentType.WORLD).required().endArgument().argument("option", ArgumentType.STRING).required().tabComplete("PvP", "ForcePvP").endArgument().argument("value", ArgumentType.STRING).required().tabComplete("ON", "OFF", "NONE").endArgument().argument("refreshMenu", ArgumentType.STRING).tabComplete("--menu").endArgument();
        }

        @Override
        public void execute(CommandSender sender, String label, List<CommandArgument> args) {
            if (args.size() < 3) {
                sender.sendMessage("\u00a7cUsage: /pmr worlds set <world> <option> <value>");
                sender.sendMessage("\u00a7cOptions: PvP, ForcePvP");
                sender.sendMessage("\u00a7cValues: ON, OFF (and NONE for ForcePvP)");
                return;
            }
            String worldName = this.getArgument(args, "world").getAsWorld().getName();
            String option = this.getArgument(args, "option").getValue();
            String value = this.getArgument(args, "value").getValue();
            CombatWorld combatWorld = Worlds.this.plugin.getWorldManager().getWorld(worldName);
            if (combatWorld == null) {
                sender.sendMessage(String.valueOf(Lang.PREFIX) + " \u00a7cThere is no world with that name: " + worldName);
                return;
            }
            if (option.equalsIgnoreCase("PvP")) {
                boolean pvp = value.equalsIgnoreCase("ON");
                combatWorld.setCombatAllowed(pvp);
                Worlds.this.plugin.getWorldManager().saveWorldData(combatWorld);
                sender.sendMessage(String.format("%s \u00a7aPvP in world '%s' set to: \u00a7e%s", Lang.PREFIX, worldName, pvp ? "ENABLED" : "DISABLED"));
            } else if (option.equalsIgnoreCase("ForcePvP")) {
                try {
                    CombatWorld.WorldOptionState state = CombatWorld.WorldOptionState.valueOf(value.toUpperCase());
                    combatWorld.setForcePVP(state);
                    Worlds.this.plugin.getWorldManager().saveWorldData(combatWorld);
                    sender.sendMessage(String.format("%s \u00a7aForce PvP in world '%s' set to: \u00a7e%s", Lang.PREFIX, worldName, state.name()));
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage("\u00a7cInvalid ForcePvP value. Use: ON, OFF, or NONE");
                }
            } else {
                sender.sendMessage("\u00a7cInvalid option. Use 'PvP' or 'ForcePvP'");
            }
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (this.hasArgument(args, "refreshMenu")) {
                    Worlds.this.createWorldMenu(player);
                }
            }
        }
    }
}

