/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.listener;

import me.chancesd.pvpmanager.manager.PlayerManager;
import me.chancesd.pvpmanager.player.CombatPlayer;
import me.chancesd.pvpmanager.sdutils.scheduler.ScheduleUtils;
import me.chancesd.pvpmanager.setting.Conf;
import me.chancesd.pvpmanager.setting.ItemCooldown;
import me.chancesd.pvpmanager.setting.Lang;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;

public class PlayerListener1_11
implements Listener {
    private final PlayerManager playerHandler;

    public PlayerListener1_11(PlayerManager ph) {
        this.playerHandler = ph;
    }

    @EventHandler
    public void onProjectileLaunchEvent(ProjectileLaunchEvent event) {
        Projectile entity = event.getEntity();
        ProjectileSource shooter = entity.getShooter();
        ItemCooldown itemCooldown = Conf.ITEM_COOLDOWNS.asMap().get(Material.ENDER_PEARL);
        if (itemCooldown == null || entity.getType() != EntityType.ENDER_PEARL || !(shooter instanceof Player)) {
            return;
        }
        Player player = (Player)shooter;
        CombatPlayer pvPlayer = this.playerHandler.get(player);
        ScheduleUtils.runPlatformTask(() -> pvPlayer.setItemCooldown(Material.ENDER_PEARL, itemCooldown), (Entity)player);
    }

    @EventHandler
    public void onEntityRessurrect(EntityResurrectEvent event) {
        if (!Conf.BLOCK_TOTEM_UNDYING.asBool() || event.isCancelled() || event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getEntity();
        CombatPlayer pvPlayer = this.playerHandler.get(player);
        if (pvPlayer.isInCombat()) {
            event.setCancelled(true);
            pvPlayer.message(Lang.TOTEM_BLOCKED_IN_COMBAT);
        }
    }
}

