/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.manager;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import me.chancesd.pvpmanager.PvPManager;
import me.chancesd.pvpmanager.sdutils.config.ConfigUpdater;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.sdutils.utils.Utils;
import me.chancesd.pvpmanager.setting.Conf;
import me.chancesd.pvpmanager.setting.Lang;
import me.chancesd.pvpmanager.setting.LogFile;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    private static final String CONFIG_VERSION = "Config Version";
    private static final String CONFIG_NAME = "config.yml";
    private static final String HOOKS_CONFIG_NAME = "plugin-hooks.yml";
    private final PvPManager plugin;
    private final File configFile;
    private final LogFile log;
    private final File pluginHooksFile;
    private final YamlConfiguration pluginHooksConfig;
    private int oldVersion;

    public ConfigManager(PvPManager plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), CONFIG_NAME);
        this.pluginHooksFile = new File(plugin.getDataFolder(), HOOKS_CONFIG_NAME);
        this.prepareFile(this.pluginHooksFile, HOOKS_CONFIG_NAME);
        this.loadConfig();
        this.log = new LogFile(new File(plugin.getDataFolder(), "combatlogs.log"));
        this.pluginHooksConfig = this.loadYamlConfiguration(this.pluginHooksFile);
    }

    private void loadConfig() {
        this.checkConfigVersion();
        this.initConfig();
    }

    private void checkConfigVersion() {
        int currentVersion;
        if (!this.configFile.exists()) {
            return;
        }
        this.plugin.reloadConfig();
        Configuration defaults = this.plugin.getConfig().getDefaults();
        this.oldVersion = this.plugin.getConfig().getInt(CONFIG_VERSION, 0);
        int n = currentVersion = defaults != null ? defaults.getInt(CONFIG_VERSION) : 0;
        if (this.oldVersion == 0) {
            Utils.renameFile(this.configFile, "config_with_errors.yml");
            Log.warning("Due to an error reading the config, it was reset to default settings");
            Log.warning("This was likely caused by a mistake while you changed settings, like an extra space or missing quotes");
            Log.warning("The broken config was renamed to config_with_errors.yml, you can copy your old settings manually if you need them");
            Lang.queueAdminMsg(String.valueOf(Lang.PREFIX) + " \u00a7cDue to an error reading the config, it was reset to default settings\n\u00a7cThis was likely caused by a mistake while you changed settings, like an extra space or missing quotes");
            Lang.queueAdminMsg(String.valueOf(Lang.PREFIX) + " \u00a7cThe broken config was renamed to config_with_errors.yml, you can copy your old settings manually if needed");
            return;
        }
        if (this.isMajorVersionUpgrade()) {
            Utils.renameFile(this.configFile, "config_v3_old.yml");
            Log.warning("The config and messages file were restored to default since v4.0 is a major version update");
            Log.warning("You can find your old files in the plugin folder with _v3_old at the end, like config_v3_old.yml");
            Lang.queueAdminMsg(String.valueOf(Lang.PREFIX) + " \u00a7aThe config and messages were upgraded and set to default since \u00a76v4.0 is a major version update");
            Lang.queueAdminMsg("");
            Lang.queueAdminMsg("\u00a7aYou can find your old files in the plugin folder with \u00a7e_v3_old\u00a7a at the end, like \u00a7econfig_v3_old.yml");
            return;
        }
        if (this.oldVersion < currentVersion) {
            try {
                ConfigUpdater.update((Plugin)this.plugin, CONFIG_NAME, this.configFile, Arrays.asList("Item Cooldowns.Combat", "Item Cooldowns.Global"), Arrays.asList(CONFIG_VERSION, "Metrics", "Update Check.Enabled"));
                ConfigUpdater.update((Plugin)this.plugin, HOOKS_CONFIG_NAME, this.pluginHooksFile, Lists.newArrayList(), Lists.newArrayList());
                Log.infoColor("\u00a7aConfig file updated from version \u00a7c" + this.oldVersion + " \u00a7ato version \u00a7c" + currentVersion);
                Log.warning("Checking the config file and adjusting the new settings is highly recommended");
                Lang.queueAdminMsg(String.valueOf(Lang.PREFIX) + " \u00a7aConfiguration updated from version \u00a7c" + this.oldVersion + " \u00a7ato \u00a7c" + currentVersion);
                Lang.queueAdminMsg(String.valueOf(Lang.PREFIX) + " \u00a7aChecking the config file and adjusting the new settings is highly recommended");
            }
            catch (IOException e) {
                Log.severe("Error reading the config file!", e);
                Utils.renameFile(this.configFile, "config_with_errors.yml");
            }
        }
    }

    private void initConfig() {
        if (!this.configFile.exists()) {
            this.prepareFile(this.configFile, CONFIG_NAME);
            Log.infoColor(String.valueOf(ChatColor.DARK_GREEN) + "New config file created successfully!");
        }
        YamlConfiguration yamlConfig = this.loadYamlConfiguration(this.configFile);
        Configuration defaults = this.plugin.getConfig().getDefaults();
        if (yamlConfig != null && defaults != null) {
            yamlConfig.setDefaults(defaults);
        }
        Conf.initialize(this.plugin, yamlConfig);
    }

    private YamlConfiguration loadYamlConfiguration(File file) {
        YamlConfiguration yamlConfiguration;
        InputStreamReader inputStream = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        try {
            yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Log.severe("Error reading the config, did you type something wrong?", e);
                return null;
            }
        }
        inputStream.close();
        return yamlConfiguration;
    }

    private void prepareFile(File file, String resource) {
        try (InputStream stream = this.plugin.getResource(resource);){
            file.getParentFile().mkdirs();
            if (file.createNewFile() && resource != null && !resource.isEmpty()) {
                this.copyResource(stream, file);
            }
        }
        catch (IOException e) {
            Log.severe("Error creating config file", e);
        }
    }

    private void copyResource(InputStream resource, File file1) {
        try (FileOutputStream out = new FileOutputStream(file1);){
            int lenght;
            byte[] buf = new byte[1024];
            while ((lenght = resource.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, lenght);
            }
            resource.close();
        }
        catch (Exception e) {
            Log.severe("Error copying config file", e);
        }
    }

    public boolean isMajorVersionUpgrade() {
        return this.oldVersion != 0 && this.oldVersion < 200;
    }

    public YamlConfiguration getHooksConfig() {
        return this.pluginHooksConfig;
    }

    public LogFile getLog() {
        return this.log;
    }
}

