/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.player;

import java.util.UUID;
import me.chancesd.pvpmanager.player.world.CombatWorld;
import me.chancesd.pvpmanager.sdutils.utils.MCVersion;
import me.chancesd.pvpmanager.setting.Lang;
import me.chancesd.pvpmanager.setting.Permissions;
import me.chancesd.pvpmanager.utils.CombatUtils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class BasePlayer {
    @NotNull
    private final Player player;
    @NotNull
    private final UUID uuid;
    private CombatWorld combatWorld;
    private long actionBarCooldown;
    private String lastActionBarMessage;
    private boolean wasAllowedFlight;

    protected BasePlayer(@NotNull Player player) {
        this.player = player;
        this.uuid = player.getUniqueId();
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final String getName() {
        return this.getPlayer().getName();
    }

    @NotNull
    public final UUID getUUID() {
        return this.uuid;
    }

    public final boolean isOnline() {
        return CombatUtils.isOnline(this.uuid);
    }

    public CombatWorld getCombatWorld() {
        return this.combatWorld;
    }

    public void setCombatWorld(CombatWorld combatWorld) {
        this.combatWorld = combatWorld;
    }

    public boolean hasPerm(Permissions permission) {
        return permission.hasPerm(this.getPlayer());
    }

    public final void message(String message) {
        if (this.isOnline() && !message.isEmpty()) {
            this.getPlayer().sendMessage(message);
        }
    }

    public final void message(Lang message, String ... args) {
        if (this.isOnline()) {
            this.getPlayer().sendMessage(message.msg(args));
        }
    }

    public final void message(Lang message) {
        if (this.isOnline()) {
            this.getPlayer().sendMessage(message.msg());
        }
    }

    public void sendActionBar(String message, long duration) {
        if (System.currentTimeMillis() < this.actionBarCooldown || message.isEmpty() || System.currentTimeMillis() - this.actionBarCooldown < 1000L && message.equals(this.lastActionBarMessage)) {
            return;
        }
        if (MCVersion.isAtLeast(MCVersion.V1_10)) {
            if (MCVersion.isAtLeast(MCVersion.V1_20_4)) {
                this.getPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacy((String)message));
            } else if (MCVersion.isAtLeast(MCVersion.V1_16_5)) {
                this.getPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
            } else {
                this.getPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
            }
        }
        this.lastActionBarMessage = message;
        this.actionBarCooldown = System.currentTimeMillis() + duration;
    }

    public void sendActionBar(String message) {
        this.sendActionBar(message, 0L);
    }

    public String toString() {
        return "CombatPlayer[" + this.getName() + ", " + String.valueOf(this.uuid) + "]";
    }

    public boolean getWasAllowedFlight() {
        return this.wasAllowedFlight;
    }

    public void setWasAllowedFlight(boolean wasAllowedFlight) {
        this.wasAllowedFlight = wasAllowedFlight;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasePlayer)) {
            return false;
        }
        return this.uuid.equals(((BasePlayer)obj).getUUID());
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

