/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.player;

import me.chancesd.pvpmanager.player.BasePlayer;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.sdutils.utils.Utils;
import me.chancesd.pvpmanager.setting.Conf;
import me.chancesd.pvpmanager.setting.Lang;
import me.chancesd.pvpmanager.utils.CombatUtils;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class EcoPlayer
extends BasePlayer {
    private final Economy economy;

    protected EcoPlayer(@NotNull Player player, Economy economy) {
        super(player);
        this.economy = economy;
    }

    private boolean withdrawMoney(double amount) {
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)this.getPlayer(), amount);
        Log.debug("Withdraw money from " + this.getName() + " - Response: " + String.valueOf(response.type) + " " + response.amount + " " + response.balance + " " + response.errorMessage);
        return response.transactionSuccess() && response.balance > 0.0;
    }

    private void depositMoney(double amount) {
        EconomyResponse response = this.economy.depositPlayer((OfflinePlayer)this.getPlayer(), amount);
        Log.debug("Deposit money to " + this.getName() + " - Response: " + String.valueOf(response.type) + " " + response.amount + " " + response.balance + " " + response.errorMessage);
    }

    public final void applyFine() {
        double penalty = this.getMoneyPercentage(Conf.FINE_AMOUNT.asDouble());
        this.withdrawMoney(penalty);
    }

    public final void applyPenalty() {
        double penalty = this.getMoneyPercentage(Conf.MONEY_PENALTY.asDouble());
        this.withdrawMoney(penalty);
        this.message(Lang.MONEY_PENALTY.msg(CombatUtils.formatTo2Digits(penalty)));
    }

    public final boolean applyPvPDisabledFee() {
        this.message(Lang.PVP_DISABLED_FEE.msg(CombatUtils.formatTo2Digits(Conf.PVP_DISABLED_FEE.asInt())));
        return this.withdrawMoney(Conf.PVP_DISABLED_FEE.asInt());
    }

    public final void giveReward(EcoPlayer victim) {
        double moneyWon = this.getMoneyPercentage(Conf.MONEY_REWARD.asDouble());
        if (Conf.MONEY_STEAL.asBool()) {
            double vbalance = this.economy.getBalance((OfflinePlayer)victim.getPlayer());
            if (Conf.MONEY_REWARD.asDouble() <= 1.0) {
                moneyWon = Utils.roundTo2Decimal(Conf.MONEY_REWARD.asDouble() * vbalance);
            } else if (Conf.MONEY_REWARD.asDouble() > vbalance) {
                moneyWon = vbalance;
            }
            victim.withdrawMoney(moneyWon);
            victim.message(Lang.MONEY_STEAL.msg(this.getPlayer().getName(), CombatUtils.formatTo2Digits(moneyWon)));
        }
        this.depositMoney(moneyWon);
        this.message(Lang.MONEY_REWARD.msg(victim.getPlayer().getName(), CombatUtils.formatTo2Digits(moneyWon)));
    }

    public final int giveExp(EcoPlayer victim) {
        int expWon = 0;
        int exp = victim.getPlayer().getTotalExperience();
        expWon = Conf.EXP_STEAL.asDouble() <= 1.0 ? (int)(Conf.EXP_STEAL.asDouble() * (double)exp) : exp;
        this.setExp(this.getPlayer().getTotalExperience() + expWon);
        this.message(Lang.EXP_WON.msg(victim.getPlayer().getName(), expWon));
        return expWon;
    }

    public final void setExp(int exp) {
        this.getPlayer().setExp(0.0f);
        this.getPlayer().setLevel(0);
        this.getPlayer().giveExp(exp);
    }

    private double getMoneyPercentage(double percentage) {
        if (percentage > 1.0) {
            return percentage;
        }
        return Utils.roundTo2Decimal(percentage * this.economy.getBalance((OfflinePlayer)this.getPlayer()));
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

