/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import me.chancesd.pvpmanager.sdutils.command.ArgumentType;
import me.chancesd.pvpmanager.sdutils.command.BaseCommand;
import me.chancesd.pvpmanager.sdutils.command.CommandArgument;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;

public class ArgumentInfo {
    private static UnaryOperator<String> playerNotFoundMessageProvider = playerName -> "\u00a7cPlayer not found: \u00a7e" + playerName;
    private final String name;
    private final ArgumentType type;
    private boolean required = false;
    private String defValue = null;
    private String perm = null;
    private List<String> customTabCompletions = null;
    private String dependsOn = null;
    private final BaseCommand parent;

    public ArgumentInfo(String name, ArgumentType type, BaseCommand parent) {
        this.name = name;
        this.type = type;
        this.parent = parent;
    }

    public ArgumentInfo required() {
        this.required = true;
        return this;
    }

    public ArgumentInfo defaultValue(String defaultValue) {
        this.defValue = defaultValue;
        return this;
    }

    public ArgumentInfo requirePermission(String permission) {
        this.perm = permission;
        return this;
    }

    public ArgumentInfo tabComplete(String ... completions) {
        this.customTabCompletions = Arrays.asList(completions);
        return this;
    }

    public ArgumentInfo tabComplete(List<String> completions) {
        this.customTabCompletions = new ArrayList<String>(completions);
        return this;
    }

    public ArgumentInfo dependsOn(String argumentName) {
        this.dependsOn = argumentName;
        return this;
    }

    public BaseCommand endArgument() {
        if (this.parent != null) {
            this.parent.addArgumentInfo(this);
        }
        return this.parent;
    }

    public static void setPlayerNotFoundMessageProvider(UnaryOperator<String> provider) {
        playerNotFoundMessageProvider = provider;
    }

    public String getName() {
        return this.name;
    }

    public ArgumentType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defValue;
    }

    public boolean hasPermission() {
        return this.perm != null && !this.perm.isEmpty();
    }

    public String getPermission() {
        return this.perm;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public boolean hasDependency() {
        return this.dependsOn != null && !this.dependsOn.isEmpty();
    }

    public boolean isValid(CommandArgument argument) {
        try {
            switch (this.type) {
                case PLAYER: {
                    return argument.getAsPlayer() != null;
                }
                case PLAYER_OR_ALL: {
                    return argument.isWildcard() || argument.getAsPlayerOrWildcard() != null;
                }
                case INTEGER: {
                    argument.getAsInt();
                    return true;
                }
                case DOUBLE: {
                    argument.getAsDouble();
                    return true;
                }
                case BOOLEAN: {
                    argument.getAsBoolean();
                    return true;
                }
                case WORLD: {
                    argument.getAsWorld();
                    return true;
                }
                case MATERIAL: {
                    argument.getAsMaterial();
                    return true;
                }
                case DURATION: {
                    argument.getAsDuration();
                    return true;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getValidationErrorMessage(CommandArgument argument) {
        switch (this.type) {
            case PLAYER: {
                return (String)playerNotFoundMessageProvider.apply(argument.getValue());
            }
            case PLAYER_OR_ALL: {
                return (String)playerNotFoundMessageProvider.apply(argument.getValue());
            }
            case INTEGER: 
            case DOUBLE: {
                return "\u00a7c'\u00a77" + argument.getValue() + "\u00a7c' is not a valid number.";
            }
            case BOOLEAN: {
                return "\u00a7c'" + argument.getValue() + "' is not a valid boolean (true/false).";
            }
            case WORLD: {
                return "\u00a7c'" + argument.getValue() + "' is not a valid world name.";
            }
            case MATERIAL: {
                return "\u00a7c'" + argument.getValue() + "' is not a valid material name.";
            }
            case DURATION: {
                return "\u00a7c'" + argument.getValue() + "' is not a valid duration. Use formats like '30s', '5m', '2h', '1d'.";
            }
        }
        return "\u00a7c'" + argument.getValue() + "' is not valid for " + this.name + ".";
    }

    public List<String> getTabCompletions(String partial) {
        if (this.customTabCompletions != null && !this.customTabCompletions.isEmpty()) {
            return ArgumentInfo.getMatchingEntries(partial, this.customTabCompletions);
        }
        switch (this.type) {
            case PLAYER: 
            case OFFLINE_PLAYER: {
                List<String> playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
                return ArgumentInfo.getMatchingEntries(partial, playerNames);
            }
            case PLAYER_OR_ALL: {
                ArrayList<String> completions = new ArrayList<String>();
                completions.add("*");
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
                return ArgumentInfo.getMatchingEntries(partial, completions);
            }
            case WORLD: {
                List<String> worldNames = Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
                return ArgumentInfo.getMatchingEntries(partial, worldNames);
            }
            case MATERIAL: {
                List<String> materialNames = Arrays.stream(Material.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toList());
                return ArgumentInfo.getMatchingEntries(partial, materialNames);
            }
            case DURATION: {
                return ArgumentInfo.getMatchingEntries(partial, Arrays.asList("30s", "5m", "1h", "1d", "1h30m"));
            }
            case BOOLEAN: {
                return ArgumentInfo.getMatchingEntries(partial, Arrays.asList("true", "false"));
            }
            case STRING: 
            case STRING_ARRAY: {
                return ArgumentInfo.getMatchingEntries(partial, Arrays.asList(this.name));
            }
        }
        return new ArrayList<String>();
    }

    private static List<String> getMatchingEntries(String token, List<String> toFilter) {
        return toFilter.stream().filter(s -> s.toLowerCase().contains(token.toLowerCase())).collect(Collectors.toList());
    }
}

