/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import me.chancesd.pvpmanager.sdutils.command.ArgumentInfo;
import me.chancesd.pvpmanager.sdutils.command.ArgumentType;
import me.chancesd.pvpmanager.sdutils.command.CommandArgument;
import me.chancesd.pvpmanager.sdutils.display.chat.ChatMenu;
import me.chancesd.pvpmanager.sdutils.display.chat.NavigationButtons;
import me.chancesd.pvpmanager.sdutils.display.chat.content.StaticContentProvider;
import me.chancesd.pvpmanager.sdutils.utils.ChatUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public abstract class BaseCommand
implements TabExecutor {
    private static Function<CommandSender, String> noPermissionMessageProvider = sender -> "\u00a7cYou don't have permission to use this command.";
    private static Function<CommandSender, String> playerOnlyMessageProvider = sender -> "\u00a7cThis command can only be used by players.";
    private BaseCommand parentCommand;
    private PluginCommand pluginCommand;
    private final List<String> aliases = new ArrayList<String>();
    private final List<BaseCommand> subCommands = new ArrayList<BaseCommand>();
    private final Set<String> permissions = new HashSet<String>();
    private final List<ArgumentInfo> argumentInfos = new ArrayList<ArgumentInfo>();
    private String commandDisplayName = this.getClass().getSimpleName() + " Help";
    private String description = "";
    private String usage = "";
    private boolean playerOnly = false;

    protected BaseCommand() {
    }

    protected BaseCommand(PluginCommand pluginCommand) {
        this();
        this.pluginCommand = pluginCommand;
        this.alias(pluginCommand.getAliases().toArray(new String[0]));
    }

    public static void setGlobalDefaults(Function<CommandSender, String> noPermission, Function<CommandSender, String> playerOnly, UnaryOperator<String> playerNotFound) {
        noPermissionMessageProvider = noPermission;
        playerOnlyMessageProvider = playerOnly;
        ArgumentInfo.setPlayerNotFoundMessageProvider(playerNotFound);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int i;
        if (this.playerOnly && !(sender instanceof Player)) {
            sender.sendMessage(playerOnlyMessageProvider.apply(sender));
            return true;
        }
        if (!this.hasPermission(sender)) {
            sender.sendMessage(noPermissionMessageProvider.apply(sender));
            return true;
        }
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("help")) {
                int page = 1;
                if (args.length > 1) {
                    try {
                        page = Integer.parseInt(args[1]);
                        if (page < 1) {
                            page = 1;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage("\u00a7cInvalid page number!");
                        return true;
                    }
                }
                this.showHelpMenu(sender, page);
                return true;
            }
            for (BaseCommand subCommand : this.subCommands) {
                if (!subCommand.isAlias(args[0])) continue;
                String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
                return subCommand.onCommand(sender, command, args[0], subArgs);
            }
        }
        ArrayList<CommandArgument> parsedArgs = new ArrayList<CommandArgument>();
        HashSet<String> userProvidedArgs = new HashSet<String>();
        for (i = 0; i < Math.min(args.length, this.argumentInfos.size()); ++i) {
            userProvidedArgs.add(this.argumentInfos.get(i).getName());
        }
        for (i = 0; i < this.argumentInfos.size(); ++i) {
            ArgumentInfo argInfo = this.argumentInfos.get(i);
            if (i < args.length) {
                if (argInfo.hasPermission() && !sender.hasPermission(argInfo.getPermission())) {
                    sender.sendMessage(noPermissionMessageProvider.apply(sender));
                    return true;
                }
                if (argInfo.getType() == ArgumentType.STRING_ARRAY) {
                    String joinedValue = String.join((CharSequence)" ", Arrays.copyOfRange(args, i, args.length));
                    parsedArgs.add(new CommandArgument(argInfo.getName(), joinedValue));
                    break;
                }
                CommandArgument argument = new CommandArgument(argInfo.getName(), args[i]);
                if (!argInfo.isValid(argument)) {
                    sender.sendMessage(argInfo.getValidationErrorMessage(argument));
                    return true;
                }
                parsedArgs.add(argument);
                continue;
            }
            if (argInfo.isRequired()) {
                sender.sendMessage("\u00a7cMissing required argument: \u00a7e" + argInfo.getName());
                if (!this.usage.isEmpty()) {
                    sender.sendMessage("\u00a77Usage: \u00a7b" + this.usage);
                }
                return true;
            }
            if (argInfo.hasDependency()) {
                if (!userProvidedArgs.contains(argInfo.getDependsOn()) || argInfo.getDefaultValue() == null) continue;
                parsedArgs.add(new CommandArgument(argInfo.getName(), argInfo.getDefaultValue()));
                continue;
            }
            if (argInfo.getDefaultValue() == null) continue;
            parsedArgs.add(new CommandArgument(argInfo.getName(), argInfo.getDefaultValue()));
        }
        this.execute(sender, label, parsedArgs);
        return true;
    }

    public abstract void execute(CommandSender var1, String var2, List<CommandArgument> var3);

    public boolean hasPermission(CommandSender sender) {
        if (!this.permissions.isEmpty()) {
            return this.permissions.stream().anyMatch(arg_0 -> ((CommandSender)sender).hasPermission(arg_0));
        }
        if (this.parentCommand != null) {
            return this.parentCommand.hasPermission(sender);
        }
        return true;
    }

    private boolean isAlias(String input) {
        return this.aliases.stream().anyMatch(alias -> alias.equalsIgnoreCase(input));
    }

    public BaseCommand alias(String ... aliasNames) {
        this.aliases.addAll(Arrays.asList(aliasNames));
        return this;
    }

    public BaseCommand permission(String ... permissionNodes) {
        this.permissions.addAll(Arrays.asList(permissionNodes));
        return this;
    }

    public BaseCommand subCommand(String name, BaseCommand subCommand) {
        subCommand.parentCommand = this;
        subCommand.aliases.add(name);
        this.subCommands.add(subCommand);
        return this;
    }

    public BaseCommand description(String descriptionText) {
        this.description = descriptionText;
        return this;
    }

    public BaseCommand usage(String usageText) {
        this.usage = usageText;
        return this;
    }

    public BaseCommand displayName(String displayNameText) {
        this.commandDisplayName = displayNameText;
        return this;
    }

    public BaseCommand playerOnly() {
        this.playerOnly = true;
        return this;
    }

    public ArgumentInfo argument(String name, ArgumentType type) {
        return new ArgumentInfo(name, type, this);
    }

    public void addArgumentInfo(ArgumentInfo argumentInfo) {
        this.argumentInfos.add(argumentInfo);
    }

    public CommandArgument getArgument(List<CommandArgument> args, String name) {
        for (CommandArgument arg : args) {
            if (!name.equals(arg.getName())) continue;
            return arg;
        }
        return null;
    }

    public boolean hasArgument(List<CommandArgument> args, String name) {
        return this.getArgument(args, name) != null;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArgumentInfo argInfo;
        if (args.length > 1) {
            if (args[0].equalsIgnoreCase("help") && args.length == 2) {
                return ChatUtils.getMatchingEntries(args[1], Arrays.asList("1", "2", "3", "4", "5"));
            }
            for (BaseCommand subCommand : this.subCommands) {
                if (!subCommand.isAlias(args[0]) || !subCommand.hasPermission(sender)) continue;
                String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
                return subCommand.onTabComplete(sender, command, args[0], subArgs);
            }
        }
        if (args.length == 1 && !this.subCommands.isEmpty()) {
            List<String> subCommandAliases = this.subCommands.stream().filter(sub -> sub.hasPermission(sender)).flatMap(sub -> sub.aliases.stream()).collect(Collectors.toList());
            subCommandAliases.add("help");
            return ChatUtils.getMatchingEntries(args[0], subCommandAliases);
        }
        int argIndex = args.length - 1;
        if (argIndex < this.argumentInfos.size() && (!(argInfo = this.argumentInfos.get(argIndex)).hasPermission() || sender.hasPermission(argInfo.getPermission()))) {
            return argInfo.getTabCompletions(args[argIndex]);
        }
        return new ArrayList<String>();
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public List<String> getAliases() {
        return new ArrayList<String>(this.aliases);
    }

    public List<BaseCommand> getSubCommands() {
        return new ArrayList<BaseCommand>(this.subCommands);
    }

    public Set<String> getPermissions() {
        return new HashSet<String>(this.permissions);
    }

    public boolean isPlayerOnly() {
        return this.playerOnly;
    }

    public ChatMenu generateHelpMenu(CommandSender sender) {
        String mainCommandName;
        StaticContentProvider contentProvider = new StaticContentProvider();
        if (!this.description.isEmpty()) {
            contentProvider.addLine("#FFEB3B&l\u25ba " + this.description, null, null);
            contentProvider.addLine("", null, null);
        }
        if (!this.usage.isEmpty()) {
            contentProvider.addLine("#9E9E9E&lUsage: &8" + this.usage, null, null);
            contentProvider.addLine("", null, null);
        }
        List availableSubCommands = this.subCommands.stream().filter(subCmd -> subCmd.hasPermission(sender)).collect(Collectors.toList());
        String string = mainCommandName = this.aliases.isEmpty() ? this.pluginCommand.getName().toLowerCase() : this.aliases.get(0);
        if (!availableSubCommands.isEmpty()) {
            contentProvider.addLine("#4CAF50&l\u25ba Available Commands:", null, null);
            for (BaseCommand subCmd2 : availableSubCommands) {
                String subCommandName = subCmd2.aliases.isEmpty() ? "unknown" : subCmd2.aliases.get(0);
                String subDescription = subCmd2.getDescription().isEmpty() ? "No description available" : subCmd2.getDescription();
                String subUsage = subCmd2.usage.isEmpty() ? "" : subCmd2.usage;
                String commandLine = "  #4CAF50/" + mainCommandName + " " + subCommandName + " #9E9E9E- &f" + subDescription;
                String hoverText = this.buildSubcommandHoverText(subDescription, subUsage, subCmd2.getPermissions());
                String suggestCommand = "/" + mainCommandName + " " + subCommandName;
                contentProvider.addLine(commandLine, suggestCommand, hoverText);
            }
        } else {
            contentProvider.addLine("#FF5722No subcommands available or no permissions.", null, null);
        }
        return ChatMenu.builder().header("#607D8B&l\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550 #FFEB3B&l" + this.commandDisplayName + " #9E9E9E(Page {page}/{total}) #607D8B&l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557").footer("#607D8B&l\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d").linesPerPage(14).contentProvider(contentProvider).navigation(NavigationButtons.builder().navigationPrefix("/" + mainCommandName + " help").previousText("#9E9E9E[#FF5722\u00ab Previous Page#9E9E9E]").nextText("#9E9E9E[#FF5722Next Page \u00bb#9E9E9E]").build()).build();
    }

    public void showHelpMenu(CommandSender sender, int page) {
        this.generateHelpMenu(sender).show(sender, page);
    }

    public void showHelpMenu(CommandSender sender) {
        this.showHelpMenu(sender, 1);
    }

    private String buildSubcommandHoverText(String description, String usage, Set<String> permissions) {
        boolean hasPermissions;
        StringBuilder hover = new StringBuilder();
        hover.append("#9E9E9EClick to see command usage\n");
        hover.append("#9E9E9E&o").append(description);
        boolean hasUsage = !usage.isEmpty();
        boolean bl = hasPermissions = !permissions.isEmpty();
        if (hasUsage || hasPermissions) {
            hover.append("\n");
        }
        if (hasUsage) {
            hover.append("\n#4CAF50&lUsage: &8").append(usage);
        }
        if (hasPermissions) {
            hover.append("\n#FF5722&lRequires: #c98d81").append(String.join((CharSequence)", ", permissions));
        }
        return hover.toString();
    }
}

