/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import me.chancesd.pvpmanager.sdutils.database.Database;
import me.chancesd.pvpmanager.sdutils.database.Table;

public interface Converter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public boolean onDatabaseLoad(Database database) {
        try (Connection connection = database.getConnection();){
            if (!this.needsConversion(database)) return false;
            Table oldTable = this.getOldTable();
            try (PreparedStatement ps = connection.prepareStatement("SELECT * FROM " + oldTable.getName());
                 ResultSet entries = ps.executeQuery();){
                this.convertAll(database, entries);
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            database.getPlugin().getLogger().log(Level.WARNING, "Failed to convert database", e);
        }
        return false;
    }

    public void onComplete();

    default public boolean needsConversion(Database database) {
        return database.getPlugin().getConfig().getInt("Database Version") < this.getMinimumDatabaseVersion();
    }

    public Table getOldTable();

    public Table getNewTable();

    public int getMinimumDatabaseVersion();

    public void convertAll(Database var1, ResultSet var2) throws SQLException;
}

