/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.library;

import java.io.Reader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import me.chancesd.pvpmanager.sdutils.library.MavenCentralDependency;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.sdutils.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.yaml.snakeyaml.reader.UnicodeReader;

public class PluginLibraries {
    private PluginLibraries() {
    }

    public static boolean checkDependencies(Plugin plugin) {
        if (PluginLibraries.hasLibraries()) {
            return true;
        }
        AtomicBoolean isLoaded = new AtomicBoolean(true);
        Consumer<Exception> error = ex -> {
            Log.info(ex.getMessage());
            ex.printStackTrace();
            isLoaded.set(false);
        };
        Consumer<String> loaded = name -> Log.info("Library " + name + " loaded!");
        YamlConfiguration description = YamlConfiguration.loadConfiguration((Reader)new UnicodeReader(plugin.getResource("plugin.yml")));
        List libraries = description.getList("libraries");
        if (libraries != null) {
            libraries.forEach(lib -> {
                String[] split = lib.toString().split(":");
                if (split.length == 3) {
                    new MavenCentralDependency(plugin, split[0], split[1], split[2]).load(loaded, error);
                }
            });
        }
        return isLoaded.get();
    }

    public static void loadDependency(Plugin plugin, String group, String artifact, String version, String pattern, String relocated) {
        MavenCentralDependency dependency = pattern.isEmpty() ? new MavenCentralDependency(plugin, group, artifact, version) : new MavenCentralDependency(plugin, group, artifact, version).withRelocation(pattern, relocated);
        dependency.load(name -> Log.info("Library " + name + " loaded!"), ex -> {
            Log.info(ex.getMessage());
            ex.printStackTrace();
        });
    }

    public static void loadDependency(Plugin plugin, String group, String artifact, String version) {
        PluginLibraries.loadDependency(plugin, group, artifact, version, "", "");
    }

    public static boolean hasLibraries() {
        try {
            PluginDescriptionFile.class.getMethod("getLibraries", new Class[0]);
            if (!Utils.isVersionAtLeast(Utils.stripTags(Bukkit.getVersion()), "1.21")) {
                try {
                    Class.forName("com.mohistmc.MohistMCStart");
                    return false;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

