/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.scheduler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import me.chancesd.pvpmanager.sdutils.scheduler.SDTask;
import me.chancesd.pvpmanager.sdutils.scheduler.SchedulerProvider;
import me.chancesd.pvpmanager.sdutils.scheduler.WrappedFoliaTask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class FoliaProvider
implements SchedulerProvider {
    @NotNull
    private final JavaPlugin plugin;

    public FoliaProvider(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void runPlatformAsync(Runnable task) {
        Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, scheduledTask -> task.run());
    }

    @Override
    public void runPlatformAsyncTimer(Runnable task, long delay, long period) {
        Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> task.run(), delay / 20L, period / 20L, TimeUnit.SECONDS);
    }

    @Override
    public void runTask(Runnable task) {
        Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin, task);
    }

    @Override
    public void runTask(Runnable task, World world, int x, int z) {
        Bukkit.getRegionScheduler().execute((Plugin)this.plugin, world, x, z, task);
    }

    @Override
    public void runTask(Runnable task, Entity entity) {
        entity.getScheduler().run((Plugin)this.plugin, scheduledTask -> task.run(), task);
    }

    @Override
    public void runTaskLater(Runnable task, long delay) {
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> task.run(), delay);
    }

    @Override
    public void runTaskLater(Runnable task, Entity entity, long delay) {
        entity.getScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> task.run(), task, delay);
    }

    @Override
    public SDTask runTaskTimer(Runnable task, Entity entity, long delay, long period) {
        return new WrappedFoliaTask(entity.getScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> task.run(), null, delay, period));
    }

    @Override
    public void executeConsoleCommand(String command) {
        Bukkit.getGlobalRegionScheduler().execute((Plugin)this.plugin, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command));
    }

    @Override
    public void executePlayerCommand(Player player, String command) {
        player.performCommand(command);
    }

    @Override
    public boolean isPrimaryThread() {
        return Bukkit.isGlobalTickThread();
    }

    @Override
    public CompletableFuture<Boolean> teleport(Entity entity, Location loc) {
        return entity.teleportAsync(loc);
    }

    @Override
    public void cancelAllTasks() {
        Bukkit.getAsyncScheduler().cancelTasks((Plugin)this.plugin);
        Bukkit.getGlobalRegionScheduler().cancelTasks((Plugin)this.plugin);
    }
}

