/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.utils;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import me.chancesd.pvpmanager.sdutils.utils.NCDuration;

public final class TimeUtil {
    private static final ChronoUnit[] types = new ChronoUnit[]{ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS};

    private TimeUtil() {
    }

    public static String getDiffUntil(TimeLangProvider lang, long date) {
        return TimeUtil.getDiffMsg(lang, Instant.now(), Instant.ofEpochMilli(date));
    }

    public static String getDiffUntil(Class<? extends Enum<? extends TimeLangProvider>> langClass, long date) {
        TimeLangProvider provider = TimeUtil.getProviderFromClass(langClass);
        return TimeUtil.getDiffUntil(provider, date);
    }

    public static String getDiffDuration(TimeLangProvider lang, long date) {
        return TimeUtil.getDiffMsg(lang, Instant.now(), Instant.now().plusMillis(date));
    }

    public static String getDiffDuration(Class<? extends Enum<? extends TimeLangProvider>> langClass, long durationMs) {
        TimeLangProvider provider = TimeUtil.getProviderFromClass(langClass);
        return TimeUtil.getDiffDuration(provider, durationMs);
    }

    public static String getDiffMsg(TimeLangProvider lang, Instant from, Instant to) {
        boolean future = false;
        if (to.equals(from)) {
            return lang.getTime(ChronoUnit.FOREVER);
        }
        if (to.isAfter(from)) {
            future = true;
        }
        NCDuration duration = NCDuration.between(from, to).plusMillis(future ? 50L : -50L);
        StringBuilder sb = new StringBuilder();
        int accuracy = 0;
        for (int i = 0; i < types.length && accuracy < 2; ++i) {
            int value = duration.get(types[i]);
            if (value <= 0) continue;
            ++accuracy;
            sb.append(" ").append(value).append(" ").append(lang.getTime(types[i]));
        }
        if (sb.isEmpty()) {
            return lang.getTime(ChronoUnit.FOREVER);
        }
        return sb.toString().trim();
    }

    private static TimeLangProvider getProviderFromClass(Class<? extends Enum<? extends TimeLangProvider>> langClass) {
        try {
            Enum<? extends TimeLangProvider>[] constants = langClass.getEnumConstants();
            if (constants != null && constants.length > 0) {
                return (TimeLangProvider)((Object)constants[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static interface TimeLangProvider {
        public String getTime(ChronoUnit var1);
    }
}

