/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.storage;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.chancesd.pvpmanager.player.CombatPlayer;
import me.chancesd.pvpmanager.sdutils.database.DatabaseConfigBuilder;
import me.chancesd.pvpmanager.sdutils.utils.Log;

public interface Storage {
    public boolean userExists(UUID var1);

    default public boolean userExists(CombatPlayer player) {
        return this.userExists(player.getUUID());
    }

    public Map<String, Object> getUserData(UUID var1);

    default public Map<String, Object> getUserData(CombatPlayer player) {
        return this.getUserData(player.getUUID());
    }

    public void removeUserData(UUID var1);

    default public void removeUserData(CombatPlayer player) {
        this.removeUserData(player.getUUID());
    }

    public boolean saveUserData(UUID var1, Map<String, Object> var2);

    default public void saveUserData(CombatPlayer player) {
        long start = System.nanoTime();
        this.saveUserData(player.getUUID(), player.exportPlayerData().toMap());
        Log.debug("Finished saving " + String.valueOf(player) + " - " + (double)(System.nanoTime() - start) / 1000000.0 + " ms");
    }

    public List<Map<String, Object>> getAllUserData();

    public void saveUserDataBatch(Collection<CombatPlayer> var1);

    public void increment(String var1, UUID var2);

    public Map<String, Object> getWorldData(String var1);

    public boolean saveWorldData(String var1, Map<String, Object> var2);

    public void shutdown();

    public DatabaseConfigBuilder.DatabaseType getDatabaseType();
}

